/*******************************************************************************
 *	Client.cc	HomeNet RPC protocol test client
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <iostream>
#include <stdio.h>
#include <stdlib.h>
#include <BString.h>
#include <TestD.h>
#include <TestC.h>
#include <TestS.h>

class Callback : public Test::LightCallbackService, public BThread  {
public:
		Callback(BoapServer& server, BString name = "") : Test::LightCallbackService(server, name){}
	BError	setLevel(Int32 level);
	void*	function();
private:
};

BError Callback::setLevel(Int32 level){
	BError	err;
	
	printf("Callback called: %d\n", level);
	
	return err;
}

void*	Callback::function(){
	oserver.run();
}

void* function(void* data){
	BoapServer*	bs = (BoapServer*)data;
	
	bs->run();
}

int main(int argc, char** argv){
	BoapServer	server;
	Callback	s(server);
	Test::Light	client("test");
	BError		err;

	if(err = server.init("", BoapServer::THREADED)){
		std::cerr << err.getString() << "\n";
		return 1;
	}

	printf("Callback Object: %s\n", s.name().retStr());

	s.start();
	printf("Server running\n");

	err = client.setCallback(s.name());

	printf("Test1\n");
	err = client.setLevel(22);
	
	sleep(5);
	pause();
	
	return 0;
}
