/*
* Title:	BGraphControl.cpp
* Author:	M.Thomas BEAM Ltd
* Date:		2007-05-31
*
* Contents:
*
*
*/


#include <BGraphControls.h>
#include <qlayout.h>
#include <Debug.h>

BGraphControlBasic::BGraphControlBasic(QWidget *p) : QWidget(p) {
	QHBoxLayout*	h = new QHBoxLayout(this);

	omax = 100;

	h->setSpacing(5);
	h->setMargin(5);
	oscroll = new QScrollBar(Qt::Horizontal,this);
	ozoomIn = new QPushButton("Zoom In",this,"");
	ozoomOut = new QPushButton("Zoom Out",this,"");
	
	oscroll->setMaxValue(1000);
	oscroll->setMinValue(0);
	
	h->addWidget(oscroll);
	h->addWidget(ozoomIn);
	h->addWidget(ozoomOut);
	
	ozoomOut->setMaximumWidth(70);
	ozoomIn->setMaximumWidth(70);

	connect(oscroll,SIGNAL(valueChanged(int)),this,SLOT(scroll()));
	connect(ozoomOut,SIGNAL(clicked()),this,SLOT(zoomOut()));
	connect(ozoomIn,SIGNAL(clicked()),this,SLOT(zoomIn()));
#ifdef ZAP
	connect(plot,SIGNAL(zoomEvent()),this,SLOT(updateScrollbar()));
	connect(plot,SIGNAL(scrollEvent()),this,SLOT(updateScrollbar()));
	connect(plot,SIGNAL(initControls()),this,SLOT(updateScrollbar()));
#endif	
}

void BGraphControlBasic::addGraph(BGraph* graph) {
	ographs.append(graph);
}

void BGraphControlBasic::setMax(double max) {
	omax = max;
	updateScrollbar();
}


void BGraphControlBasic::zoomIn() {
	zoom(1);
}



void BGraphControlBasic::zoomOut() {
	zoom(0);
}

void BGraphControlBasic::zoom(int in) {
	BIter	i;
	double 	oldMin = 0;
	double  oldMax = 0;
	double 	oldRange = 0;
	double 	newRange = 0;
	double	newMin = 0;
	double	newMax = 0;
	
	for (ographs.start(i);! ographs.isEnd(i);ographs.next(i)) { 

		ographs[i]->getXRange(oldMin,oldMax);
		
		oldRange = oldMax - oldMin;

		if (in)
			newRange = oldRange/2;
		else
			newRange = oldRange * 2;
		
		if (newRange < 16)
			newRange = 16;
		if (newRange > omax)
			newRange = omax;
		
		
		newMin = oldMin;
		newMax = oldMin + newRange;	

		if (newMax > omax) {
			newMax = omax;
			newMin = omax - newRange;
		}
		ographs[i]->setXRange(newMin,newMax);
	}	
	if (gdebug & 0xffff) {
		printf("zoomMe\n");
		printf("omax (%f) oldMin (%f) oldMax (%f) oldRange (%f)\n",omax,oldMin,oldMax,oldRange);
		printf("omax (%f) newMin (%f) newMax (%f) newRange (%f)\n",omax,newMin,newMax,newRange);
	}	

	updateScrollbar();
}

void BGraphControlBasic::scroll(int val) {
	oscroll->setValue(oscroll->value() + val);
	scroll();
}

void BGraphControlBasic::scroll() {
	BIter	i;
	double	oldMin = 0,oldMax = 0;
	double	newMin = 0,newMax = 0;
	double	range = 0;
	
	for (ographs.start(i);! ographs.isEnd(i);ographs.next(i)) { 
		ographs[i]->getXRange(oldMin,oldMax);

		range = oldMax - oldMin;

		newMin = oscroll->value();
		newMax = newMin + range;
		
		if (newMax > omax) {
			newMax = omax;
			newMin = omax - range;
		}
		ographs[i]->setXRange(newMin,newMax);
	}
	
	if (gdebug & 0x1000) {
		printf("ScrollMe (%d)\n",oscroll->value());
		printf("omax (%f) oldmin (%f) oldmax (%f) nmin (%f) nmax (%f)\n",omax,oldMin,oldMax,newMin,newMax);
	}	
	
}

void BGraphControlBasic::updateScrollbar() {
	double	min,max;
	int	page;
	int	smax;
	int	range;
	
	
	ographs[ographs.end()]->getXRange(min,max);
	range = (int)(max - min);
	page = range;
	smax = (int)(omax - range);

	if (gdebug & 0x1000) {
		printf("Update Scrollbar - value (%d) page (%d) smax (%d)\n",(int)min,page,smax);
		printf("omax (%f) min (%f) max (%f)\n",omax,min,max);
	}	
	
	disconnect(oscroll,SIGNAL(valueChanged(int)),this,SLOT(scroll()));
	oscroll->setValue((int)min);
	oscroll->setMaxValue(smax);
	oscroll->setPageStep(page);
	connect(oscroll,SIGNAL(valueChanged(int)),this,SLOT(scroll()));
}



