/*******************************************************************************
 *	TmsControlClient2.cpp	TMS API example code
 *			T.Barnaby,	BEAM Ltd,	2007-02-07
 *******************************************************************************
 *
 *	This is a very basic example of using the TmsApi to set the
 *	TMS's cycleNumber and cycleType.
 *	It is designed to give an overview of using the API.
 */
#include <iostream>
#include <stdio.h>
#include <unistd.h>
#include <TmsD.h>
#include <TmsC.h>

using namespace Tms;
using namespace std;

// Loop sending next cycle information
BError tmsControlLoop(TmsControl& tmsControl){
	BError			err;
	BUInt32			cn = 0;
	BString			ct = "Beam3";
	
	while(1){
		// Wait for next cycle information
		usleep(1200000);

		// Set next cycle information
		cn = cn + 1;
		ct = "Beam3";

		printf("SendNextCycle\n");				
		// Send the next cycle information to the TMS server
		if(err = tmsControl.setNextCycle(cn, ct)){
			cerr << "Error: " << err.getString() << "\n";
		}
	}	

	return err;
}

int main(int argc, char** argv){
	BError			err;
	BString			host = "localhost";
	TmsControl		tmsControl;

	if(argc == 2)
		host = argv[1];

	// Connect to the Control service
	if(err = tmsControl.connectService(BString("//") + host + "/tmsControl1")){
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}

	// Set the network priority high
	if(err = tmsControl.setPriority(BSocket::PriorityHigh)){
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}

	// Set the TmsServer thread priority high
	if(err = tmsControl.setProcessPriority(PriorityHigh)){
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}

	if(err = tmsControlLoop(tmsControl)){	
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}

	return 0;
}
