/*******************************************************************************
 *	BError.h	BError Class
 *			T.Barnaby,	BEAM Ltd,	21/3/00
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BERROR_H
#define BERROR_H	1

#include <BString.h>

#if CERN_TMS
enum BErrorNum {
	ErrorOk = 0, ErrorMisc = 1, ErrorWarning = 2,ErrorInit = 3, ErrorConfig = 4, 
	ErrorParam = 5, ErrorNotImplemented = 6,
	ErrorComms = 7, ErrorCommsTimeout = 8, ErrorMC = 9,
	ErrorFpga = 10, ErrorStateTable = 11, ErrorCycleNumber = 12,
	ErrorDataNotAvailable = 13, ErrorDataGone = 14, ErrorDataFuture = 15,
	ErrorTimeout = 16,

	ErrorNotAvailable = 20, ErrorData = 21, ErrorChecksum = 22, ErrorOverrun = 23, ErrorUnderrun = 24,
	ErrorResourceLimit = 25, ErrorEndOfFile = 26, ErrorFile = 27, ErrorFormat = 28, ErrorAccessDenied = 29,
	ErrorNoData = 30, ErrorEndOfData = 31, ErrorDataPresent = 32,
	ErrorAppBase = 64 };
#else
enum BErrorNum {
	ErrorOk = 0, ErrorMisc = 1, ErrorWarning = 2, ErrorParam = 3, ErrorTimeout = 4,
	ErrorNotAvailable = 5, ErrorData = 6, ErrorChecksum = 7, ErrorOverrun = 8, ErrorUnderrun = 9,
	ErrorInit = 10, ErrorConfig = 11, ErrorNotImplemented = 12, ErrorResourceLimit = 13,
	ErrorEndOfFile = 14, ErrorFile = 15, ErrorFormat = 16, ErrorComms = 17, ErrorAccessDenied = 18,
	ErrorNoData = 19, ErrorEndOfData = 20, ErrorDataPresent = 21,
	ErrorAppBase = 64 };
#endif

/// Error return class
class BError {
public:
			BError(int errNo = ErrorOk, BString errStr = "");	///< Create object
			BError(BString errStr);				///< Create with error set and error string

	BError		copy();						///< Return an independant copy
				
	BError&		set(int errNo, BString errStr = "");		///< Set error number and message
	BError&		clear();					///< Clear the error
	BError&		setError(BString errStr = "");			///< Set error type ERROR with optional message


	BString		getString() const;				///< Get error message
	int		getNumber() const;				///< Get The error number

	int		num() const;					///< Get The error number
	const char*	str() const;					///< Return a char* string
	
	// Old functions
	int		getErrorNo() const;				///< Get The error number

			operator int() const;				///< Return error number
private:
	int		oerrNo;
	BString		oerrStr;
	
};

inline BError::operator int () const {
	return oerrNo;
}

#endif
