/*******************************************************************************
 *	Gui.h		General Gui Interface
 *			T.Barnaby,	BEAM Ltd,	2005-09-29
 *******************************************************************************
 */
#ifndef GUI_H
#define GUI_H	1

#include <stdint.h>
#include <BError.h>
#include <Control.h>
#include <tmsControlMainWin.h>


class tmsControlMainWin;

/// This is the system's GUI class. It implements the GUI for the DataLogger.
class Gui {
public:
			Gui(Control& control);
			~Gui();
			
	BError		init(int argc, char** argv);	///< Initialise the GUI
	void		run();				///< Run the GUI
	
private:
	QApplication*		oapp;			///< Qt application	
	TmsControlMainWin*	oappGui;		///< Primary GUI
	Control&		ocontrol;		///< The main control object
};

#endif
