/*******************************************************************************
 *	TmsPuApi.cc	Produced by Bidl
 *******************************************************************************
 */

#include <stdlib.h>
#include <stdint.h>
#include <TmsPuApi.h>
#include <Control.h>
#include <main.h>

using namespace Tms;

PuControlServer::PuControlServer(Control& control, BoapServer& server, BString name) : PuControlService(server, name), ocontrol(control){
}

BError PuControlServer::getVersion(BString& version){
	BError	err;

	version = VERSION;
	
	return err;
}

BError PuControlServer::init(){
	return ocontrol.initCmd();
}

BError PuControlServer::setProcessPriority(BUInt32 priority){
	return ocontrol.setProcessPriority(priority);
}

BError PuControlServer::configure(BUInt32 ring, ConfigInfo configInfo){
	return ocontrol.configure(ring, configInfo);
}

BError PuControlServer::setControlInfo(CycleParam params){
	return ocontrol.setControlInfo(params);
}

BError PuControlServer::setNextCycle(BUInt32 cycleNumber, BString cycleType){
	return ocontrol.setNextCycle(cycleNumber, cycleType);
}

BError PuControlServer::test(BList<BError>& errors){
	return ocontrol.test(errors);
}

BError PuControlServer::getStatus(BList<NameValue>& statusList){
	return ocontrol.getStatus(statusList);
}

BError PuControlServer::getStatistics(BList<NameValue>& statsList){
	return ocontrol.getStatistics(statsList);
}

BError PuControlServer::getMasterPuChannel(PuChannel& puChannel){
	return ocontrol.getMasterPuChannel(puChannel);
}

BError PuControlServer::setTestMode(PuChannel puChannel, BUInt32 testOutput, BUInt32 timingDisableMask){
	return ocontrol.setTestMode(puChannel, testOutput, timingDisableMask);
}

BError PuControlServer::setTimingSignals(PuChannel puChannel, BUInt32 timingSignals){
	return ocontrol.setTimingSignals(puChannel, timingSignals);
}

BError PuControlServer::captureDiagnostics(PuChannel puChannel, TestCaptureInfo captureInfo, BArray<BUInt64>& data){
	return ocontrol.captureDiagnostics(puChannel, captureInfo, data);
}
BError PuControlServer::setTestData(PuChannel puChannel, BInt32 on, BArray<BUInt32> data){
	return ocontrol.setTestData(puChannel, on, data);
}
BError PuControlServer::setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig){
	return ocontrol.setPupeConfig(puPhysChannel, pupeConfig);
}
BError PuControlServer::getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig){
	return ocontrol.getPupeConfig(puPhysChannel, pupeConfig);
}




PuProcessServer::PuProcessServer(Control& control, BoapServer& server, BString name) : PuProcessService(server, name), ocontrol(control){
}

BError PuProcessServer::getVersion(BString& version){
	BError	err;

	version = VERSION;
	
	return err;
}

BError PuProcessServer::addEventServer(BString name){
	return ocontrol.addEventServer(name);
}

BError PuProcessServer::getStatus(PuChannel puChannel, PuStatus& puStatus){
	return ocontrol.getStatus(puChannel, puStatus);
}

BError PuProcessServer::getCycleInformation(BUInt32 cycleNumber, CycleInformation& cycleInformation){
	return ocontrol.getCycleInformation(cycleNumber, cycleInformation);
}

BError PuProcessServer::getData(PuChannel puChannel, DataInfo dataInfo, Data& data, BUInt32& orbitNumber){
	return ocontrol.getData(puChannel, dataInfo, data, orbitNumber);
}

BError PuProcessServer::requestData(PuChannel puChannel, DataInfo dataInfo){
	return ocontrol.requestData(puChannel, dataInfo);
}

