/*******************************************************************************
 *	BError.cc	BError Class
 *			T.Barnaby,	BEAM Ltd,	21/3/00
 *******************************************************************************
 */
#include <BError.h>


BError::BError(int errNo, BString errStr){
	oerrNo = errNo;
	oerrStr = errStr;
}

BError::BError(BString errStr){
	oerrNo = ErrorMisc;
	oerrStr = errStr;
}

BError BError::copy(){
	return BError(oerrNo, oerrStr.copy());
}

BError& BError::set(int errNo, BString errStr){
	oerrNo = errNo;
	oerrStr = errStr;
	return *this;
}

BError& BError::clear(){
	set(ErrorOk, "");
	return *this;
}

BError& BError::setError(BString errStr){
	set(ErrorMisc, errStr);
	return *this;
}

BString BError::getString() const {
	return oerrStr;
}

int BError::getNumber() const {
	return oerrNo;
}

int BError::num() const {
	return oerrNo;
}

const char* BError::str() const {
	return oerrStr;
}

int BError::getErrorNo() const {
	return oerrNo;
}

