/*******************************************************************************
 *	TmsWatchdog.cc	Watchdog process
 *			T.Barnaby,	BEAM Ltd,	2008-01-18
 *******************************************************************************
 */
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <linux/watchdog.h>

int main(){
	int	fd;
	int	e;
	int	v;
	
	if((fd = open("/dev/watchdog", O_RDWR)) < 0){
		fprintf(stderr, "Unable to open: /dev/watchdog: %s\n", strerror(errno));
		return 1;
	}

	v = 60;
	ioctl(fd, WDIOC_SETTIMEOUT, &v);
	v = 0;
	ioctl(fd, WDIOC_SETPRETIMEOUT, &v);
	
	
	while(1){
		e = ioctl(fd, WDIOC_KEEPALIVE, 0);
		fsync(fd);
		sleep(10);
	}

	write(fd, "V", 1);

	return 0;
}
