/*******************************************************************************
 *	BTypes.h	Basic Types
 *			T.Barnaby,	BEAM Ltd,	1/4/05
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BTYPES_H
#define BTYPES_H	1

#include <stdint.h>
#include <sys/types.h>
#include <vector>

// The standard types
typedef bool			Bool;
typedef int8_t			BInt8;
typedef uint8_t			BUInt8;
typedef int16_t			BInt16;
typedef uint16_t		BUInt16;
typedef int32_t			BInt32;
typedef uint32_t		BUInt32;
typedef int64_t			BInt64;
typedef uint64_t		BUInt64;
typedef float			BFloat32;
typedef double			BFloat64;
typedef char			BChar;

// Generic
typedef BInt32			BInt;
typedef BUInt32			BUInt;
typedef BFloat32		BFloat;
typedef BFloat64		BDouble;
typedef size_t			BSize;
typedef std::vector<BFloat32>	BArrayFloat;
typedef std::vector<BFloat64>	BArrayDouble;

// Timeouts
typedef BUInt32			BTimeout;
const BTimeout	BTimeoutForever = 0xFFFFFFFF;		// Forever timeout

// Convert timeout to system ticks. Note system tick rate hard coded as ms
inline BTimeout timeoutTicks(BTimeout timeoutUs){
	if(timeoutUs == BTimeoutForever)
		return timeoutUs;
	else
		return timeoutUs / 1000;
}

// Byte swap routines
inline void byteSwap8(void* d, void* s){
	char*	dp = (char*)d;
	char*	sp = (char*)s;

	*dp = *sp;
}
inline void byteSwap16(void* d, void* s){
	char*	dp = (char*)d;
	char*	sp = (char*)s;

	dp[1] = sp[0];
	dp[0] = sp[1];
}
inline void byteSwap32(void* d, void* s){
	char*	dp = (char*)d;
	char*	sp = (char*)s;

	dp[3] = sp[0];
	dp[2] = sp[1];
	dp[1] = sp[2];
	dp[0] = sp[3];
}
inline void byteSwap64(void* d, void* s){
	char*	dp = (char*)d;
	char*	sp = (char*)s;

	dp[7] = sp[0];
	dp[6] = sp[1];
	dp[5] = sp[2];
	dp[4] = sp[3];
	dp[3] = sp[4];
	dp[2] = sp[5];
	dp[1] = sp[6];
	dp[0] = sp[7];
}

// BObj member information
enum BType	{ BTypeNone, BTypeBool, BTypeInt8, BTypeUInt8, BTypeInt16, BTypeUInt16, BTypeInt32, BTypeUInt32, BTypeInt64, BTypeUInt64, BTypeFloat32, BTypeFloat64, BTypeChar, BTypeString, BTypeError, BTypeTime, BTypeObj = 100 };
enum BTypeComp	{ BTypeCompSingle, BTypeCompArray, BTypeCompArrayFixed, BTypeCompList, BTypeCompDict };

struct BObjMember {
	BType		type;
	BTypeComp	typeComp;
	BUInt16		dataOffset;
	BUInt16		size;
	const char*	typeName;
	const char*	name;
};

#endif
