/*******************************************************************************
 *	BRefData.h		Referenced data storage
 *				T.Barnaby,	Beam Ltd,	6/10/94
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BREFDATA_H
#define	BREFDATA_H	1

#include <BAtomicCount.h>

/// Referenced data storage. This is Thread safe to a degree. The reference counting is
/// protected. However, setLen() is not and should be protected at a higher level.
class BRefData {
public:
			BRefData();
			BRefData(int len);
			BRefData(const BRefData& refData);
			~BRefData();

	BRefData*	copy();			///< Create a copy of this reference for writing, if necessary				
	BRefData*	addRef();		///< Increment the reference counter
	int		deleteRef();		///< Decrement the reference counter

	char*		data(){	return (char*)odata; }	///< Return the raw data pointer
	int		len(){ return olen; }		///< Return the length in bytes

	BRefData&	operator=(const BRefData& refData);

	void		setLen(int len);	///< Set the length in bytes. Note should only be used if orefCount = 1

private:

	BAtomicCount	orefCount;		///< The reference count, how many users
	int		olen;			///< The actual length of data in oData
	void*		odata;			///< Pointer to the data
};


#endif
