/*******************************************************************************
 *	Server.cc	HomeNet RPC protocol test server
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <BString.h>
#include <TestC.h>
#include <TestD.h>
#include <TestS.h>

class Server : public Test::LightService {
public:
		Server(BoapServer& server, BString name) : Test::LightService(server, name){}
	BError	setLevel(Int32 level);
	BError	setCallback(BString name);
private:
	BString			oremName;
	Test::LightCallback	ocallback;
};

BError	Server::setLevel(Int32 level){
	BError	err;

	printf("SetLevel: %d\n", level);
	err = ocallback.setLevel(level);
	printf("Callback Error: %d %s\n", err.getErrorNo(), err.getString().retStr());

	return err;
}

BError	Server::setCallback(BString name){
	BError	err;
	
	printf("SetCallback: %s\n", name.retStr());	
	oremName = name;
	ocallback.disconnectService(oremName);
	err = ocallback.connectService(oremName);
	printf("Callback Error: %d %s\n", err.getErrorNo(), err.getString().retStr());
	
	return err;
}

int main(int argc, char** argv){
	BoapServer		server;
	Server			s(server, "test");
	BError			err;

	printf("Server Starting\n");	
	if(err = server.init("", BoapServer::THREADED)){
		std::cerr << err.getString() << "\n";
		return 1;
	}

	server.run();
	
	pause();
	
	return 0;
}
