/***************************************************************************
 *	BGraph.h	Graph plotter
 *			T.Barnaby,	BEAM Ltd,	2007-05-31
 ***************************************************************************
 */
#ifndef	BGraph_H
#define BGraph_H	1

#include <BString.h>
#include <BArray.h>
#include <qgrid.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qtimer.h>
#include <qpointarray.h>
#include <qlabel.h>

class BGraph;

class BGraphPlot : public QWidget {
public:
			BGraphPlot(QWidget* parent, BGraph* cp);
protected:
	void		resizeEvent(QResizeEvent* event);
	void		paintEvent(QPaintEvent* event);
private:
	BGraph*		ocp;
};

class BGraph: public QGrid {
	Q_OBJECT
public:
	enum GainMode		{ AUTO, FIXED };
	enum PlotType		{ LINES, POINTS };
	
				BGraph(QWidget* parent);
				~BGraph();

	void			setData(BArray<float> data);		///< Set Plot data
	void			getData(BArray<float>& data);		///< Get Plot data

	void			setPlotType(PlotType plotType);
	void			setGrid(int xStep, int yStep);
	void			setXLabel(BString label);
	void			setYLabel(BString label);
	void			setYRange(double min, double max);	///< Sets the YRange, optional
	void			setXRange(double min, double max);	///< Sets the YRange, optional

	void			setYLabelWidth(int width);
	void			getXRange(double& min, double& max);
	
	void			redraw();		///< Re-draw the plot
	void			drawLabels();
	void			drawGrid();
	void			drawPlot();
public slots:
	void			clear();		///< Clear the plot and all data
private:
	PlotType		oplotType;
	double			oxRangeMin;
	double			oxRangeMax;
	double			oyRangeMin;
	double			oyRangeMax;
	double			oyMinValue;
	double			oxMaxValue;
	double			oxMinValue;
	double			oyMaxValue;
	BString			oxLabel;
	BString			oyLabel;
	BArray<float>		odata;			///< The data buffer
	int			oxGridStep;
	int			oyGridStep;
	
	QWidget*		oyLabelBox;		///< The Y label widget
	QWidget*		ocorner;		///< The Corner widget
	QWidget*		oxLabelBox;		///< The X label widget
	QHBox*			oplotFrame;		///< The frame around the plot
	BGraphPlot*		oplot;			///< The actual plot

	QPointArray		opoints;		////< Temporary array for polt updates
	QColor			ocolor;			///< The graph draw colour
};

#endif
