-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_top_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module instantiates the main design logic of memory 
-- 			   interface and interfaces with the user.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;

entity mem_interface_small_top_0 is 
generic( use_chipscope     : in boolean);
port (
      clk_0                : in std_logic;
      clk_90               : in std_logic;
      clk_50               : in std_logic;
      ref_clk              : in std_logic;
      sys_rst              : in std_logic;
      sys_rst90            : in std_logic;
      sys_rst_ref_clk_1    : in std_logic;
      
      idelay_ctrl_rdy      : in std_logic;
      DDR2_RAS_N           : out std_logic;
      DDR2_CAS_N           : out std_logic;
      DDR2_WE_N            : out std_logic;
      DDR2_ODT             : out std_logic_vector(odt_width-1 downto 0);
      DDR2_CKE             : out std_logic_vector(cke_width-1 downto 0);   
      DDR2_CS_N            : out std_logic_vector(cs_width-1 downto 0);
      DDR2_DQ              : inout std_logic_vector(data_width-1 downto 0);
      DDR2_DQS             : inout std_logic_vector(data_strobe_width-1 downto 0);
      DDR2_DQS_N           : inout std_logic_vector(data_strobe_width-1 downto 0);
      DDR2_DM    : out std_logic_vector(data_mask_width-1 downto 0); 
      
      DDR2_CK              : out std_logic_vector(clk_width-1 downto 0);
      DDR2_CK_N            : out std_logic_vector(clk_width-1 downto 0);
      DDR2_BA              : out std_logic_vector(bank_address-1 downto 0);
      DDR2_A               : out std_logic_vector(row_address-1 downto 0);
      WDF_ALMOST_FULL      : out std_logic;
      AF_ALMOST_FULL       : out std_logic;
      BURST_LENGTH         : out std_logic_vector(2 downto 0);
      READ_DATA_VALID      : out std_logic;
      READ_DATA_FIFO_OUT   : out std_logic_vector(dq_width*2-1 downto 0);
      APP_AF_ADDR          : in std_logic_vector(35 downto 0);
      APP_AF_WREN          : in std_logic;
      APP_WDF_DATA         : in std_logic_vector(dq_width*2-1 downto 0);
      APP_MASK_DATA        : in std_logic_vector(dm_width*2-1 downto 0);
      APP_WDF_WREN         : in std_logic;
      CLK_TB               : out std_logic;
      RESET_TB             : out std_logic;
      chip_scope_control   : in std_logic_vector(35 downto 0);
      error                : out std_logic
      );

end entity;

architecture arc_top of mem_interface_small_top_0 is



component mem_interface_small_data_path_0
port (
      CLK                  : in std_logic;
      CLK90                : in std_logic;
      CAL_CLK              : in std_logic;
      RESET0               : in std_logic;
      RESET90              : in std_logic;
      RESET_CAL_CLK        : in std_logic;
      CTRL_DUMMYREAD_START : in std_logic;
      idelay_ctrl_rdy      : in std_logic;      
      WDF_DATA             : in std_logic_vector(dq_width*2-1 downto 0);
      MASK_DATA            : in std_logic_vector(dm_width*2-1 downto 0);      
      CTRL_WREN            : in std_logic;
      CTRL_DQS_RST         : in std_logic;
      CTRL_DQS_EN          : in std_logic;
      CTRL_DUMMY_WR_SEL    : in std_logic;
      dummy_write_flag	   : in std_logic;
      dqs_delayed          : in std_logic_vector(data_strobe_width-1 downto 0);
      wr_data_rise         : out std_logic_vector(data_width-1 downto 0);
      wr_data_fall         : out std_logic_vector(data_width-1 downto 0);
      mask_data_rise       : out std_logic_vector(data_mask_width-1 downto 0);
      mask_data_fall       : out std_logic_vector(data_mask_width-1 downto 0);      
      wr_en                : out std_logic; 
      dqs_rst              : out std_logic; 
      dqs_en               : out std_logic; 
      dqs_idelay_inc       : out std_logic_vector(ReadEnable-1 downto 0);
      dqs_idelay_ce        : out std_logic_vector(ReadEnable-1 downto 0);
      dqs_idelay_rst       : out std_logic_vector(ReadEnable-1 downto 0);

      data_idelay_inc      : out std_logic_vector(ReadEnable-1 downto 0);
      data_idelay_ce       : out std_logic_vector(ReadEnable-1 downto 0);
      data_idelay_rst      : out std_logic_vector(ReadEnable-1 downto 0);
      
      SEL_DONE             : out std_logic
      );

end component;

component mem_interface_small_iobs_0 
port (
      CLK                  : in std_logic;
      CLK90                : in std_logic;
      DDR_CK		   : out std_logic_vector(clk_width-1 downto 0);	 
      DDR_CK_N		   : out std_logic_vector(clk_width-1 downto 0);	  
      CAL_CLK              : in std_logic;
      RESET0               : in std_logic;
      RESET90              : in std_logic;
          
      dqs_idelay_inc	   : in std_logic_vector(ReadEnable-1 downto 0);
      dqs_idelay_ce	   : in std_logic_vector(ReadEnable-1 downto 0);
      dqs_idelay_rst	   : in std_logic_vector(ReadEnable-1 downto 0);
      dqs_rst		   : in std_logic;	
      dqs_en               : in std_logic; 
      wr_en      	   : in std_logic;

      dqs_delayed          : out std_logic_vector(data_strobe_width-1 downto 0);
      data_idelay_inc      : in std_logic_vector(ReadEnable-1 downto 0);
      data_idelay_ce       : in std_logic_vector(ReadEnable-1 downto 0);  
      data_idelay_rst      : in std_logic_vector(ReadEnable-1 downto 0); 
            
      wr_data_rise         : in std_logic_vector(data_width-1 downto 0);
      wr_data_fall         : in std_logic_vector(data_width-1 downto 0);
      mask_data_rise       : in std_logic_vector(data_mask_width-1 downto 0);
      mask_data_fall       : in std_logic_vector(data_mask_width-1 downto 0);      
      rd_data_rise         : out std_logic_vector(data_width-1 downto 0);
      rd_data_fall         : out std_logic_vector(data_width-1 downto 0);

      DDR_DQ               : inout std_logic_vector(data_width-1 downto 0);
      DDR_DQS              : inout std_logic_vector(data_strobe_width-1 downto 0);
      DDR_DQS_L            : inout std_logic_vector(data_strobe_width-1 downto 0);
      DDR_DM	           : out std_logic_vector(data_mask_width-1 downto 0);			
      DDR_ADDRESS          : out std_logic_vector(row_address-1 downto 0);
      DDR_BA               : out std_logic_vector(bank_address-1 downto 0);
      DDR_RAS_L            : out std_logic;
      DDR_CAS_L            : out std_logic;
      DDR_WE_L             : out std_logic;
      DDR_cs_L             : out std_logic_vector(cs_width-1 downto 0);  
      DDR_CKE              : out std_logic_vector(cke_width-1 downto 0);  
      DDR_ODT              : out std_logic_vector(odt_width-1 downto 0);  
      ctrl_ddr2_ras_L      : in std_logic;
      ctrl_ddr2_cas_L      : in std_logic;
      ctrl_ddr2_we_L       : in std_logic;
      ctrl_ddr2_odt        : in std_logic_vector(odt_width-1 downto 0);
      ctrl_ddr2_cke        : in std_logic_vector(cke_width-1 downto 0);     
      ctrl_ddr2_cs_L       : in std_logic_vector(cs_width-1 downto 0);    
      ctrl_ddr2_ba         : in std_logic_vector(bank_address-1 downto 0);
      ctrl_ddr2_address    : in std_logic_vector(row_address-1 downto 0)

       
      
      );
end component;                   



             
component  mem_interface_small_user_interface_0
port (
        CLK                   : in std_logic;
       clk90                 : in std_logic;
       
       RESET                 : in std_logic;
       READ_DATA_RISE        : in std_logic_vector(data_width-1 downto 0);
       READ_DATA_FALL        : in std_logic_vector(data_width-1 downto 0);
       
       APP_AF_ADDR           : in std_logic_vector(35 downto 0);
       APP_AF_WREN           : in std_logic;
       CTRL_AF_RDEN          : in std_logic;
       APP_WDF_DATA          : in std_logic_vector(dq_width*2-1 downto 0);
       APP_MASK_DATA         : in std_logic_vector(dm_width*2-1 downto 0);     
       APP_WDF_WREN          : in std_logic;
       CTRL_WDF_RDEN         : in std_logic;
       CTRL_RDEN             : in std_logic; 
  	 
       COMP_DONE             : out std_logic; 
       READ_DATA_FIFO_OUT    : out std_logic_vector(dq_width*2-1 downto 0);
       READ_DATA_VALID       : out std_logic;
       AF_ADDR               : out std_logic_vector(35 downto 0);
       WDF_DATA              : out std_logic_vector(dq_width*2-1 downto 0);
       MASK_DATA             : out std_logic_vector(dm_width*2-1 downto 0);
       WDF_ALMOST_FULL       : out std_logic;
       AF_ALMOST_FULL        : out std_logic;
       AF_EMPTY              : out std_logic;
       TEST_BUS              : out std_logic_vector(3 downto 0)

       );
end component;



component  mem_interface_small_ddr2_controller_0
port (
                   clk0                   : in std_logic; -- controller input
                   refresh_clk            : in std_logic; -- controller input
                   rst                    : in std_logic; -- controller input
                   af_addr                : in std_logic_vector(35 downto 0); --FIFO  signal
	           af_empty              : in std_logic;                     --FIFO  signal
                   phy_Dly_Slct_Done      : in std_logic;  --Input signal for the Dummy Reads
                   COMP_DONE              : in std_logic;
		   ctrl_dummy_wr_sel      : out std_logic;
		   burst_length           : out std_logic_vector(2 downto 0);
                   ctrl_Dummyread_Start   : out std_logic;    
                   ctrl_af_RdEn           : out std_logic;--FIFO read enable signals
                   ctrl_Wdf_RdEn          : out std_logic;-- FIFO read enable signals  
                   ctrl_Dqs_Rst           : out std_logic;  -- Rst and Enable signals for DQS logic  
                   ctrl_Dqs_En            : out std_logic;  -- Rst and Enable signals for DQS logic  
                   ctrl_WrEn              : out std_logic;   --Read and Write Enable signals to the phy interface 
                   ctrl_RdEn              : out std_logic;    --Read and Write Enable signals to the phy interface
                   ctrl_ddr2_address      : out std_logic_vector((row_address-1) downto 0);    
                   ctrl_ddr2_ba           : out std_logic_vector((bank_address-1) downto 0);   
                   ctrl_ddr2_ras_L        : out std_logic;    
                   ctrl_ddr2_cas_L        : out std_logic;    
                   ctrl_ddr2_we_L         : out std_logic;    
                   ctrl_ddr2_cs_L         : out std_logic_vector((cs_width-1) downto 0);   
                   ctrl_ddr2_cke          : out std_logic_vector((cke_width-1) downto 0); 
                   ctrl_ddr2_odt          : out std_logic_vector((odt_width-1) downto 0);
			 dummy_write_flag	      : out std_logic
				  );
end component;

signal wr_df_data            : std_logic_vector(dq_width*2-1 downto 0);
signal mask_df_data 	     : std_logic_vector(dm_width*2-1 downto 0);
signal rd_data_rise          : std_logic_vector(data_width-1 downto 0);
signal rd_data_fall          : std_logic_vector(data_width-1 downto 0);

signal af_empty_w            : std_logic; 

signal dq_tap_sel_done       : std_logic;
signal af_addr               : std_logic_vector(35 downto 0);
signal ctrl_af_rden          : std_logic;
signal ctrl_wr_df_rden       : std_logic;
signal ctrl_dummy_rden       : std_logic;
signal ctrl_dqs_enable       : std_logic;
signal ctrl_dqs_reset        : std_logic;
signal ctrl_wr_en            : std_logic;
signal ctrl_rden             : std_logic ;

signal dqs_idelay_inc  : std_logic_vector(ReadEnable-1 downto 0);
signal dqs_idelay_ce   : std_logic_vector(ReadEnable-1 downto 0);
signal dqs_idelay_rst  : std_logic_vector(ReadEnable-1 downto 0);
signal data_idelay_inc : std_logic_vector(ReadEnable-1 downto 0);
signal data_idelay_ce  : std_logic_vector(ReadEnable-1 downto 0);
signal data_idelay_rst : std_logic_vector(ReadEnable-1 downto 0);

signal dqs_rst         : std_logic;                                    
signal dqs_en          : std_logic;                                    
signal wr_en           : std_logic;    

signal wr_data_rise    : std_logic_vector((data_width-1) downto 0);
signal wr_data_fall    : std_logic_vector((data_width-1) downto 0);
signal dqs_delayed     : std_logic_vector((data_strobe_width-1) downto 0);
signal mask_data_rise  : std_logic_vector(data_mask_width-1 downto 0);
signal mask_data_fall  : std_logic_vector(data_mask_width-1 downto 0);

signal ctrl_ddr2_address     : std_logic_vector(row_address-1 downto 0);
signal ctrl_ddr2_ba	     : std_logic_vector(bank_address-1 downto 0);
signal ctrl_ddr2_ras_L	     : std_logic;
signal ctrl_ddr2_cas_L	     : std_logic;
signal ctrl_ddr2_we_L	     : std_logic;
signal ctrl_ddr2_cs_L	     : std_logic_vector(cs_width-1 downto 0);
signal ctrl_ddr2_cke	     : std_logic_vector(cke_width-1 downto 0);
signal ctrl_ddr2_odt	     : std_logic_vector(odt_width-1 downto 0);
signal DDR2_DM_r  	     : std_logic_vector(data_mask_width-1 downto 0);		
signal ctrl_dummy_wr_sel     : std_logic;
signal COMP_DONE             : std_logic;

signal dummy_write_flag	     : std_logic;
signal TEST_BUS              : std_logic_vector(3 downto 0);
signal READ_DATA_FIFO_OUT_i  : std_logic_vector(dq_width*2-1 downto 0);

--------------------------------------------------------------------------------
-- Chipscope

        signal trig0            : std_logic_vector (254 downto 0);
    
        component ila
            port(
                control     : in    std_logic_vector(35 downto 0);
                clk         : in    std_logic;
                trig0       : in    std_logic_vector(254 downto 0));
        end component;
--------------------------------------------------------------------------------


begin                                   

  CLK_TB <=clk_0;
  RESET_TB <= sys_rst; 

  DDR2_DM <=  DDR2_DM_r   ; 
  READ_DATA_FIFO_OUT <= READ_DATA_FIFO_OUT_i;

  ERROR <= (NOT comp_done) OR sys_rst;
            
data_path_00 : mem_interface_small_data_path_0

             port map (
                       CLK                   => clk_0,
                       CLK90                 => clk_90,
                       CAL_CLK               => clk_50,
                       RESET0                => sys_rst,
                       RESET90               => sys_rst90,
                       RESET_CAL_CLK         => sys_rst_ref_clk_1,
                       CTRL_DUMMYREAD_START  => ctrl_dummy_rden,
                       idelay_ctrl_rdy       => idelay_ctrl_rdy,
                       WDF_DATA              => wr_df_data,
                       MASK_DATA             => mask_df_data,                       
                       CTRL_WREN             => ctrl_wr_en,
                       CTRL_DQS_RST          => ctrl_dqs_reset,
                       CTRL_DQS_EN           => ctrl_dqs_enable,
                       DQS_DELAYED           => dqs_delayed,
                       CTRL_DUMMY_WR_SEL     => ctrl_dummy_wr_sel,
                       data_idelay_inc       => data_idelay_inc,
                       data_idelay_ce        => data_idelay_ce,
                       data_idelay_rst       => data_idelay_rst,
                       dqs_idelay_inc        => dqs_idelay_inc,
                       dqs_idelay_ce         => dqs_idelay_ce,
                       dqs_idelay_rst        => dqs_idelay_rst,
                       SEL_DONE              => dq_tap_sel_done,
                       dqs_rst               => dqs_rst,
                       dqs_en                => dqs_en,
                       wr_en                 => wr_en,
                       wr_data_rise          => wr_data_rise,
                       wr_data_fall          => wr_data_fall,
                       mask_data_rise        => mask_data_rise,
                       mask_data_fall        => mask_data_fall,
		       dummy_write_flag      => dummy_write_flag

                      );
                      
   
   
 iobs_00 : mem_interface_small_iobs_0
port map (
      CLK                => clk_0,
      CLK90              => clk_90,
      CAL_CLK            => clk_50,
      RESET0             => sys_rst,
      RESET90            => sys_rst90,
      DDR_CK             => DDR2_CK,
      DDR_CK_N           => DDR2_CK_N,
      
      data_idelay_inc    => data_idelay_inc,
      data_idelay_ce     => data_idelay_ce,
      data_idelay_rst    => data_idelay_rst,
      dqs_idelay_inc     => dqs_idelay_inc,
      dqs_idelay_ce      => dqs_idelay_ce,
      dqs_idelay_rst     =>  dqs_idelay_rst,
          
      dqs_rst		 => dqs_rst,
      dqs_en             => dqs_en,
      wr_en       	 => wr_en,
      wr_data_rise       =>  wr_data_rise,
      wr_data_fall       =>  wr_data_fall,
      mask_data_rise     =>  mask_data_rise,
      mask_data_fall     =>   mask_data_fall,
      rd_data_rise       =>  rd_data_rise,
      rd_data_fall       =>  rd_data_fall,
      dqs_delayed        => dqs_delayed,
      DDR_DQ             => DDR2_DQ,
      DDR_DQS            => DDR2_DQS,
      DDR_DQS_L          => DDR2_DQS_N,
      DDR_DM             => DDR2_DM_r,
      ctrl_ddr2_address  => ctrl_ddr2_address,
      ctrl_ddr2_ba       => ctrl_ddr2_ba,
      ctrl_ddr2_ras_L    => ctrl_ddr2_ras_L,
      ctrl_ddr2_cas_L    => ctrl_ddr2_cas_L,
      ctrl_ddr2_we_L     => ctrl_ddr2_we_L,
      ctrl_ddr2_cs_L     => ctrl_ddr2_cs_L,
      ctrl_ddr2_cke      => ctrl_ddr2_cke,
      ctrl_ddr2_odt      => ctrl_ddr2_odt,
      DDR_ADDRESS        => DDR2_A,
      DDR_BA             => DDR2_BA,     
      DDR_RAS_L          =>  DDR2_RAS_N,  
      DDR_CAS_L          => DDR2_CAS_N,  
      DDR_WE_L           => DDR2_WE_N,
      DDR_CKE            => DDR2_CKE,
      DDR_ODT            => DDR2_ODT,    
      DDR_cs_L           => DDR2_CS_N                     
     
      
      );
             
 
 user_interface_00 :  mem_interface_small_user_interface_0
                  port map (
                            CLK                 => clk_0,
                            clk90               => clk_90,
                            RESET               => sys_rst,
                            CTRL_RDEN           => ctrl_rden,
                            COMP_DONE           => COMP_DONE,
                            READ_DATA_RISE      => rd_data_rise,
                            READ_DATA_FALL      => rd_data_fall,
                            READ_DATA_FIFO_OUT  => READ_DATA_FIFO_OUT_i,
                            READ_DATA_VALID     => READ_DATA_VALID,
                            AF_EMPTY            => af_empty_w,
                            AF_ALMOST_FULL      => AF_ALMOST_FULL,
                            APP_AF_ADDR         => APP_AF_ADDR,
                            APP_AF_WREN         => APP_AF_WREN,
                            CTRL_AF_RDEN        => ctrl_af_rden,
                            AF_ADDR             => af_addr,
                            APP_WDF_DATA        => APP_WDF_DATA,
			    
                            APP_MASK_DATA       => APP_MASK_DATA,
                            APP_WDF_WREN        => APP_WDF_WREN,
                            CTRL_WDF_RDEN       => ctrl_wr_df_rden,
                            WDF_DATA            =>  wr_df_data,
                            MASK_DATA           =>  mask_df_data,
                            WDF_ALMOST_FULL     =>  WDF_ALMOST_FULL,
                            TEST_BUS            =>  TEST_BUS

                            );
                     
   


ddr2_controller_00 :  mem_interface_small_ddr2_controller_0
                   port map (
                      clk0                 =>  clk_0,
                      refresh_clk          =>  ref_clk,
                      rst                  =>  sys_rst,
		      burst_length         =>  BURST_LENGTH,
                      af_addr              =>  af_addr,
                      af_empty             =>  af_empty_w,
                      phy_Dly_Slct_Done    => dq_tap_sel_done,
                      ctrl_Dummyread_Start => ctrl_dummy_rden,
                      ctrl_af_RdEn         => ctrl_af_rden,
                      ctrl_Wdf_RdEn        =>ctrl_wr_df_rden,
                      ctrl_Dqs_Rst         => ctrl_dqs_reset,
                      ctrl_Dqs_En          => ctrl_dqs_enable,
                      ctrl_WrEn            => ctrl_wr_en,
                      ctrl_RdEn            => ctrl_rden,
                      ctrl_ddr2_address    => ctrl_ddr2_address,
                      ctrl_ddr2_ba         => ctrl_ddr2_ba,
                      ctrl_ddr2_ras_L      => ctrl_ddr2_ras_L,
                      ctrl_ddr2_cas_L      => ctrl_ddr2_cas_L,
                      ctrl_ddr2_we_L       => ctrl_ddr2_we_L,
                      ctrl_ddr2_cs_L       => ctrl_ddr2_cs_L,
                      ctrl_ddr2_cke        => ctrl_ddr2_cke,
                      ctrl_ddr2_odt        => ctrl_ddr2_odt,
 		      ctrl_dummy_wr_sel    => ctrl_dummy_wr_sel,
                      COMP_DONE            => COMP_DONE,
		      dummy_write_flag     =>   dummy_write_flag
); 


scope2: if use_chipscope = TRUE generate
begin
    i_ila_mem : ila
        port map(
            control   => chip_scope_control,
            clk       => clk_0,
            trig0     => trig0);    -- (254 downto 0)

        trig0(31 downto 0) <=       wr_data_rise;
        trig0(63 downto 32) <=      wr_data_fall;
        trig0(95 downto 64) <=      rd_data_rise;
        trig0(127 downto 96) <=     rd_data_fall;
        trig0(128) <=               dqs_idelay_inc(0);
        trig0(129) <=               dqs_idelay_ce(0);
        trig0(130) <=               dqs_idelay_rst(0);
        trig0(131) <=               data_idelay_inc(0);
        trig0(132) <=               data_idelay_ce(0);
        trig0(133) <=               data_idelay_rst(0);
        trig0(134) <=               dq_tap_sel_done;
--        trig0(135) <=               ctrl_ddr2_cs_L(0);
        trig0(136) <=               sys_rst;
        trig0(137) <=               sys_rst90;     
        trig0(189 downto 138) <=    READ_DATA_FIFO_OUT_i(51 downto 0);

        trig0(209) <=               ctrl_dqs_enable;
        trig0(210) <=               ctrl_rden;
--        trig0(211) <=				ctrl_ddr2_cke(0);
        trig0(212) <= 				dqs_rst;                  
        trig0(216 downto 213) <=    TEST_BUS;
        trig0(228 downto 217) <=    READ_DATA_FIFO_OUT_i(63 downto 52);
--        trig0(233) <=               ctrl_ddr2_ras_L;
--        trig0(234) <=               ctrl_ddr2_cas_L;
--        trig0(235) <=               ctrl_ddr2_we_L;
        trig0(236) <=               ctrl_dummy_rden;
        trig0(240 downto 237) <=    mask_data_rise;
        trig0(244 downto 241) <=    mask_data_fall;
        trig0(253) <=               COMP_DONE;
--        trig0(254) <=               ctrl_ddr2_odt(0);




end generate;   
   
   
                             
end arc_top;      
