-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_infrastructure_iobs_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : The DDR2 memory clocks are generated here using the 
-- 			   differential buffers and the ODDR elemnts in the IOBs.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

entity  mem_interface_small_infrastructure_iobs_0 is 
port ( CLK 		     : in std_logic;
       DDR_CK	     : out std_logic_vector(clk_width-1 downto 0);
       DDR_CK_N	     : out std_logic_vector(clk_width-1 downto 0)
       
       );
end entity;       

architecture arc_infrastructure_iobs of  mem_interface_small_infrastructure_iobs_0 is
 component OBUFDS
   port (

         I   : in std_logic;
         O   : out  std_logic;
         OB  : out  std_logic
        );
end component;

component ODDR
generic(
    DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
    SRTYPE       : string := "SYNC"
    );
port(
    Q           : out std_ulogic;
    C           : in  std_ulogic;
    CE          : in  std_ulogic;
    D1          : in  std_ulogic;
    D2          : in  std_ulogic;
    R           : in  std_ulogic;
    S           : in  std_ulogic
  );
end component;
signal DDR_CK_q : std_logic_vector((clk_width-1) downto 0);
signal DDR_CK_N_q : std_logic_vector((clk_width-1) downto 0);

signal vcc            : std_logic;
signal gnd            : std_logic;



begin
vcc         <= '1';
gnd         <= '0';

 -- DDR_CK <=  DDR_CK_q;
 -- DDR_CK_N <= DDR_CK_N_q;              

oddr_clk0 : ODDR
generic map(
                DDR_CLK_EDGE => "OPPOSITE_EDGE",
                SRTYPE       => "SYNC"
                  )
       port map(
                Q  => DDR_CK_q(0),
                C  => CLK,
                CE => vcc,
                D1 => gnd,
                D2 => vcc,
                R  => gnd,
                S  => gnd
                );


oddr_clk1 : ODDR
generic map(
                DDR_CLK_EDGE => "OPPOSITE_EDGE",
                SRTYPE       => "SYNC"
                  )
       port map(
                Q  => DDR_CK_q(1),
                C  => CLK,
                CE => vcc,
                D1 => gnd,
                D2 => vcc,
                R  => gnd,
                S  => gnd
                );




OBUFDS0 : OBUFDS
        port map (
                   I  => DDR_CK_q(0),
                   O  => DDR_CK(0),
                   OB => DDR_CK_N(0)
                 );


OBUFDS1 : OBUFDS
        port map (
                   I  => DDR_CK_q(1),
                   O  => DDR_CK(1),
                   OB => DDR_CK_N(1)
                 );



end arc_infrastructure_iobs;
