/*******************************************************************************
 *	BEvent.cpp	Event class
 *	T.Barnaby,	BEAM Ltd,	2005-07-08
 *	Copyright (c) 2005 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#include	<BEvent.h>
#include	<BPoll.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<sys/ioctl.h>
 
BEvent::BEvent(BUInt32 type, BUInt32 arg) : otype(type), oarg(arg){
}

BUInt32 BEvent::type(){
	return otype;
}

BUInt32 BEvent::arg(){
	return oarg;
}


BEventPipe::BEventPipe(){
	pipe(ofds);
}

BEventPipe::~BEventPipe(){
	close(ofds[0]);
	close(ofds[1]);
}

void BEventPipe::clear(){
	BEvent	e;

	while(!read(e, 0));
}

int BEventPipe::getFd(){
	return ofds[0];
}

BUInt BEventPipe::writeAvailable() const {
	return 1;
}

BError BEventPipe::write(const BEvent& event,  BTimeout timeout){
	BError	err;
	
	::write(ofds[1], &event, sizeof(event));
	
	return err;
}

BUInt BEventPipe::readAvailable() const{
	int	nBytes = 0;
	
	ioctl(ofds[0], FIONREAD, &nBytes);
	
	return nBytes / sizeof(BEvent);
}

BError BEventPipe::read(BEvent& event,  BTimeout timeout){
	BError		err;
	BPoll		poll;
	int		fd;
	
	if(timeout != BTimeoutForever){
		poll.append(ofds[0]);
		if(err = poll.doPoll(fd, timeout))
			return err;
	}
		
	::read(ofds[0], &event, sizeof(event));
	
	return err;
}
