/*******************************************************************************
 *	GenBoap.h	Generate output
 *			T.Barnaby,	BEAM Ltd,	2/5/03
 *******************************************************************************
 */
#ifndef GENBOAP_HH
#define GENBOAP_HH

#include <Gen.h>

class GenBoap : public Gen {
public:
			GenBoap();
			~GenBoap();
	BError		produce(Node* n, BString fileName);
private:
	BError		produceHeaderIntC();
	BError		produceHeaderIntS();
	BError		produceTrailerInt();
	BError		produceHeaderImpC();
	BError		produceHeaderImpS();
	BError		produceHeaderIntT();
	BError		produceHeaderImpT();

	void		produceIntC(Node* n);
	void		produceIntS(Node* n);
	void		produceImpC(Node* n);
	void		produceImpS(Node* n);
	void		produceIntT(Node* n);
	void		produceImpT(Node* n);

	void		pushPopVar(FileIndent& file, int push, BString func, Node* type, BString name);
	void		produceFuncC(Node* n);
	void		produceFuncAdd(Node* n);
	void		produceFuncS(Node* n);
	
	BString		getTypeSwapList(Node* n);
	BString		getTypeInitialiser(BString typeName);

	BString		ofileName;
	FileIndent	ofileIntC;
	FileIndent	ofileIntS;
	FileIndent	ofileImpC;
	FileIndent	ofileImpS;
	FileIndent	ofileIntT;
	FileIndent	ofileImpT;
	BString		omodule;
	BString		ointerface;
	int		ofuncNum;
	int		opushPopDepth;
	int		oapiVersion;
};

#endif
