/*******************************************************************************
 *	TmsT.cc	Produced by Bidl
 *******************************************************************************
 */

#include <stdlib.h>
#include <stdint.h>
#include <TmsApi.h>
#include <Control.h>
#include <Debug.h>
#include <main.h>

using namespace Tms;

TmsControlServer::TmsControlServer(Control& control, BoapServer& server, BString name) : TmsControlService(server, name), ocontrol(control){
}

BError TmsControlServer::getVersion(BString& version){
	BError	err;

	version = VERSION;
	
	return err;
}
BError TmsControlServer::setProcessPriority(BUInt32 priority){
	return ocontrol.setProcessPriority(priority);
}

BError TmsControlServer::init(){
	return ocontrol.initCmd();
}

BError TmsControlServer::configure(ConfigInfo configInfo){
	return ocontrol.configure(configInfo);
}

BError TmsControlServer::getConfiguration(ConfigInfo& configInfo){
	return ocontrol.getConfiguration(configInfo);
}

BError TmsControlServer::setControlInfo(CycleParam params){
	return ocontrol.setControlInfo(params);
}

BError TmsControlServer::getControlInfo(BString cycleType, UInt32 ring, UInt32 puChannel, CycleParam& params){
	return ocontrol.getControlInfo(cycleType, ring, puChannel, params);
}

BError TmsControlServer::delControlInfo(BString cycleType, UInt32 ring, UInt32 puChannel){
	return ocontrol.delControlInfo(cycleType, ring, puChannel);
}

BError TmsControlServer::getControlList(BList<CycleParamItem>& itemList){
	return ocontrol.getControlList(itemList);
}

BError TmsControlServer::setNextCycle(UInt32 cycleNumber, BString cycleType){
	return ocontrol.setNextCycle(cycleNumber, cycleType);
}

BError TmsControlServer::test(BList<BError>& errors){
	return ocontrol.test(errors);
}

BError TmsControlServer::getStatus(BList<NameValue>& statusList){
	return ocontrol.getStatus(statusList);
}

BError TmsControlServer::getStatistics(BList<NameValue>& statsList){
	return ocontrol.getStatistics(statsList);
}

BError TmsControlServer::getPuChannel(UInt32 puChannel, PuChannel& puPhysChannel){
	return ocontrol.getPuChannel(puChannel, puPhysChannel);
}

BError TmsControlServer::puServerStarted(UInt32 number){
	return ocontrol.puServerStarted(number);
}


BError TmsControlServer::setSimulation(Simulation simulation){
	return ocontrol.setSimulation(simulation);
}

BError TmsControlServer::getSimulation(Simulation& simulation){
	return ocontrol.getSimulation(simulation);
}

BError TmsControlServer::setTestMode(PuChannel puPhysChannel, UInt32 testOutput, UInt32 timingDisableMask){
	return ocontrol.setTestMode(puPhysChannel, testOutput, timingDisableMask);
}

BError TmsControlServer::setTimingSignals(PuChannel puPhysChannel, UInt32 timingSignals){
	return ocontrol.setTimingSignals(puPhysChannel, timingSignals);
}

BError TmsControlServer::captureDiagnostics(PuChannel puPhysChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data){
	return ocontrol.captureDiagnostics(puPhysChannel, captureInfo, data);
}

BError TmsControlServer::setTestData(PuChannel puPhysChannel, Int32 on, BArray<UInt32> data){
	return ocontrol.setTestData(puPhysChannel, on, data);
}

BError TmsControlServer::setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig){
	return ocontrol.setPupeConfig(puPhysChannel, pupeConfig);
}

BError TmsControlServer::getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig){
	return ocontrol.getPupeConfig(puPhysChannel, pupeConfig);
}



TmsProcessServer::TmsProcessServer(Control& control, BoapServer& server, BString name) : TmsProcessService(server, name), ocontrol(control){
}

BError TmsProcessServer::getVersion(BString& version){
	BError	err;

	version = VERSION;
	
	return err;
}


BError TmsProcessServer::getCycleInfo(UInt32& cycleNumber, BString& cycleType){
	return ocontrol.getCycleInfo(cycleNumber, cycleType);
}

BError TmsProcessServer::getCycleInformation(UInt32 cycleNumber, CycleInformation& cycleInformation){
	return ocontrol.getCycleInformation(cycleNumber, cycleInformation);
}

BError TmsProcessServer::getCycleTypeInformation(BString cycleType, CycleTypeInformation& cycleTypeInformation){
	return ocontrol.getCycleTypeInformation(cycleType, cycleTypeInformation);
}

BError TmsProcessServer::getData(DataInfo dataInfo, Data& data){
	return ocontrol.getData(dataInfo, data);
}

BError TmsProcessServer::addEventServer(BString name){
	return ocontrol.addEventServer(name);
}

BError TmsProcessServer::requestData(DataInfo dataInfo){
	return ocontrol.requestData(dataInfo);
}


TmsEventServer::TmsEventServer(Control& control, BoapServer& server, BString name) : TmsEventService(server, name), ocontrol(control){
}

BError TmsEventServer::errorEvent(UInt32 cycleNumber, BError error){
	BError	err;
	
	dprintf(DBG_EVENT, "TmsEventServer::errorEvent: %d %s\n", cycleNumber, error.getString().retStr());
	ocontrol.errorEvent(cycleNumber, error);

	return err;
}

BError TmsEventServer::cycleStartEvent(UInt32 cycleNumber){
	BError	err;
	
	dprintf(DBG_EVENT, "TmsEventServer::cycleStartEvent: %u\n", cycleNumber);
	ocontrol.cycleStartEvent(cycleNumber);

	return err;
}

BError TmsEventServer::cycleStopEvent(UInt32 cycleNumber){
	BError	err;
	
	dprintf(DBG_EVENT, "TmsEventServer::cycleStopEvent: %u\n", cycleNumber);
	ocontrol.cycleStopEvent(cycleNumber);

	return err;
}

BError TmsEventServer::dataEvent(DataInfo dataInfo){
	BError	err;

	dprintf(DBG_EVENT, "TmsEventServer::dataEvent\n");

	return err;
}
