/*******************************************************************************
 *	Gen.h		Generate output
 *			T.Barnaby,	BEAM Ltd,	12/9/03
 *******************************************************************************
 */
#ifndef GEN_HH
#define GEN_HH

#include <stdio.h>
#include <BError.h>
#include <BFile.h>
#include <Node.h>
#include <Type.h>

class FileIndent : public BFile {
public:
		FileIndent();
	void	indentMore();
	void	indentLess();
	int	writeLine(BString line);
private:
	int	oindent;
};

class Gen {
public:
			Gen();
	virtual		~Gen();
	virtual BError	produce(Node* n, BString fileName) = 0;
	
	// Utils
	BString		getTypeName(Node* n, int data = 0);
	int		isRawType(Node* n);
	int		useCopyType(Node* n);
	int		setUseBObjects(int on);
	int		getUseBObjects();
private:
	int		ouseBObjects;
};

#endif
