/***************************************************************************
 *	AppGui.cpp	Main fronend for application
 *			T.Barnaby,	BEAM Ltd,	27/6/03
 ***************************************************************************
 */
#include <stdlib.h>
#include <AppGui.h>
#include <qstatusbar.h>
#include <qmenubar.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>

AppGui::AppGui(){
}

AppGui::~AppGui(){
}

void AppGui::init(QString title){
	setCaption(title);
	initMenubar();
	initMain();
	initStatus();
	initToolbar();
}

QAction* AppGui::addAction(QPopupMenu* menu, QString name, QString menuName, QString accelKey, QString memberFunc, QString tip){
	QAction*	a;
	
	a = new QAction(name, menuName, QAccel::stringToKey(accelKey), this);
	a->setStatusTip(tip);
	a->setWhatsThis(tip);
	connect(a, SIGNAL(activated()), this, memberFunc);
	a->addTo(menu);
	return a;
}

void AppGui::initMenubar(){
	QPopupMenu*	m;
	QAction*	a;
	
	m = new QPopupMenu();
	omenus.append(m);
	a = addAction(m, tr("Quit"), tr("&Quit"), tr("Ctrl+Q"), SLOT(slotQuit()), tr("Quits the application"));
	oactions.append(a);
	menuBar()->insertItem(tr("&File"), m);
	
}


void AppGui::initToolbar() {
  
  toolbar = new QToolBar(this, "toolbar");
  QWhatsThis::whatsThisButton(toolbar);
}


void AppGui::initMain(){
	QPushButton*	b;
	
	b = new QPushButton(this, "Default AppGui Running");
	b->setText("Default AppGui Running");
	setCentralWidget(b);
}


void AppGui::initStatus() {
	statusBar()->message(tr("Ready"),10000);
}

void AppGui::slotQuit(){
	qApp->quit();
}
