/*
* Title:	ConfigureWin.h
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Configuration Data entry and control window
*
* Mod Rec:
*
*/


#ifndef CONFIGUREWIN_H
#define CONFIGUREWIN_H

#include <BString.h>
#include <Control.h>
#include <qtable.h>

/*! Configure System and setup user interface window. 
*
*/
class ConfigureWin : public QWidget {
        Q_OBJECT
public:
        ConfigureWin(QWidget* w,Control& c);
	~ConfigureWin();
	
	void	readConfig();
public slots:
	void	show();			
	void	update();		///< Update and make the widget visible

private slots:
	void	reconfigure();		///< Reconfigure callback	
	void	addChannel();		///< Add a channel number
	void	delChannel();		///< Delete highest channel number

private:
	void	warningDialog(BString title, BError err);

	Control&		ocontrol;
	
	QTable*			opuParams;
	BString			oconfigComments;

};
#endif
