/*******************************************************************************
 *	BEvent.h	Event class
 *	T.Barnaby,	BEAM Ltd,	2005-07-08
 *	Copyright (c) 2005 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BEvent_H
#define BEvent_H	1

#include <BTypes.h>
#include <BQueue.h>

enum BEventType { BEventTypeNone = 0 };

class BEvent {
public:
			BEvent(BUInt32 type = BEventTypeNone, BUInt32 arg = 0);

	BUInt32		type();
	BUInt32		arg();
	
private:
	BUInt32		otype;			///< The events type
	BUInt32		oarg;			///< The events argument
};

/// \brief This class provides an interface for sending simple integer events via a BQueue.
typedef BQueue<BEvent>	BEventQueue;


/// \brief This class provides an interface for sending simple integer events via a pipe file descriptor
class BEventPipe {
public:
			BEventPipe();
			~BEventPipe();
			
	void		clear();				///< Clear events pending
	int		getFd();

	BUInt		writeAvailable() const;
	BError		write(const BEvent& event,  BTimeout timeout = BTimeoutForever);	///< Append an item onto the queue

	BUInt		readAvailable() const;
	BError		read(BEvent& event,  BTimeout timeout = BTimeoutForever);		///< Get an item from the queue
	
private:
	int		ofds[2];			///< File descriptors for pipe
};
#endif
