/*******************************************************************************
 *	BBuffer.h	Buffer Class
 *			T.Barnaby,	BEAM Ltd,	27/2/94
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BBUFFER_H
#define BBUFFER_H	1

#include <BTypes.h>
#include <BString.h>
#include <BError.h>
#include <BComplex.h>
#include <BEndian.h>

#if IS_BIG_ENDIAN
#define	BBigEndian	1
#else
#define	BBigEndian	0
#endif

class BTimeStamp;

class BBuffer {
/// Create and manipulate a data buffer. On creation the buffer size defaults to 1024 bytes.
public:
			BBuffer(BUInt size = 0);
			~BBuffer();

	int		setSize(BUInt32 size);						///< Sets the bufer size 
	int		setData(const void* data, BUInt32 size);			///< Sets buffer data resized to contain the data
	int		writeData(BUInt32 pos, const void* data, BUInt32 size);	///< Writes data into buffer from offset pos 

	char*		data();								///< The data
	BUInt32		size();								///< Size of the buffer in bytes

	int		resize(BUInt32 size){ return setSize(size); }			///< Alternative to setSize()
protected:
	BUInt32		odataSize;
	char*		odata;
	BUInt32		osize;
};

class BBufferStore : public BBuffer{
public:
			BBufferStore(BUInt size = 0, int swapBytes = BBigEndian);
			~BBufferStore();
	
	BUInt32		getPos();
	void		setPos(BUInt32 pos);
	
	BString		getHexString();
	void		setHexString(BString s);
			
	int		push(BInt8 v);
	int		push(BUInt8 v);
	int		push(BInt16 v);
	int		push(BUInt16 v);
	int		push(BInt32 v);
	int		push(BUInt32 v);
	int		push(BInt64 v);
	int		push(BUInt64 v);
	int		push(BFloat32 v);
	int		push(BFloat64 v);
	int		push(const BString& v);
	int		push(const BError& v);
	int		push(const BTimeStamp& v);
	int		push(const BComplex& v);
	int		push(BUInt32 nBytes, const void* data, const char* swapType = "1");
	
	int		pop(BInt8& v);
	int		pop(BUInt8& v);
	int		pop(BInt16& v);
	int		pop(BUInt16& v);
	int		pop(BInt32& v);
	int		pop(BUInt32& v);
	int		pop(BInt64& v);
	int		pop(BUInt64& v);
	int		pop(BFloat32& v);
	int		pop(BFloat64& v);
	int		pop(BString& v);
	int		pop(BError& v);
	int		pop(BTimeStamp& v);
	int		pop(BComplex& v);
	int		pop(BUInt32 nBytes, void* data, const char* swapType = "1");

protected:
	BUInt32		opos;
	int		oswapBytes;
};

#endif
