/*******************************************************************************
 *	GenBData.h	Generate Data output
 *			T.Barnaby,	BEAM Ltd,	12/9/03
 *******************************************************************************
 */
#ifndef GENBDATA_HH
#define GENBDATA_HH

#include <Gen.h>

class GenBData : public Gen {
public:
	enum ObjType	{ ObjTypeStd, ObjTypeBObject, ObjTypeBObj };

			GenBData();
			~GenBData();
	BError		produce(Node* n, BString fileName);
private:
	BError		produceHeaderInt();
	BError		produceTrailerInt();
	BError		produceHeaderImp();
	BError		produceTrailerImp();
	void		produceInt(Node* n);
	void		produceImp(Node* n);

	BString		ofileName;
	FileIndent	ofileInt;
	FileIndent	ofileImp;
	BString		omodule;
	int		otypeDomain;
	int		otypeNum;
	ObjType		oobjType;
	BString		opostNamespace;
};

#endif
