/*******************************************************************************
 *	TmsApi.h	Produced by Bidl
 *******************************************************************************
 */
#ifndef TmsApi_H
#define TmsApi_H 1

#include <BString.h>
#include <BList.h>
#include <BArray.h>
#include <TmsS.h>

using namespace Tms;

class Control;

class TmsControlServer : public Tms::TmsControlService {
public:
		TmsControlServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError setProcessPriority(BUInt32 priority);
	BError init();
	BError configure(ConfigInfo configInfo);
	BError getConfiguration(ConfigInfo& configInfo);
	BError setControlInfo(CycleParam params);
	BError getControlInfo(BString cycleType, UInt32 ring, UInt32 puChannel, CycleParam& params);
	BError delControlInfo(BString cycleType, UInt32 ring, UInt32 puChannel);
	BError getControlList(BList<CycleParamItem>& itemList);
	BError setNextCycle(UInt32 cycleNumber, BString cycleType);
	BError test(BList<BError>& errors);
	BError getStatus(BList<NameValue>& statusList);
	BError getStatistics(BList<NameValue>& statsList);
	BError getPuChannel(UInt32 puChannel, PuChannel& puPhysChannel);
	BError puServerStarted(UInt32 number);
	BError setSimulation(Simulation simulation);
	BError getSimulation(Simulation& simulation);
	BError setTestMode(PuChannel puPhysChannel, UInt32 testOutput, UInt32 timingDisableMask);
	BError setTimingSignals(PuChannel puPhysChannel, UInt32 timingSignals);
	BError captureDiagnostics(PuChannel puPhysChannel, TestCaptureInfo captureInfo, BArray<UInt64>& data);
	BError setTestData(PuChannel puPhysChannel, Int32 on, BArray<UInt32> data);	///< This function will set a PU channel to sample data from memory rather than the ADC's
	BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig);
	BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig);
private:
	Control&	ocontrol;
};

class TmsProcessServer : public Tms::TmsProcessService {
public:
		TmsProcessServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError getCycleInfo(UInt32& cycleNumber, BString& cycleType);
	BError getCycleInformation(UInt32 cycleNumber, CycleInformation& cycleInformation);
	BError getCycleTypeInformation(BString cycleType, CycleTypeInformation& cycleTypeInformation);
	BError getData(DataInfo dataInfo, Data& data);

	BError addEventServer(BString name);
	BError requestData(DataInfo dataInfo);
private:
	Control&	ocontrol;
};

class TmsEventServer : public Tms::TmsEventService {
public:
		TmsEventServer(Control& control, BoapServer& server, BString name);
	BError errorEvent(UInt32 cycleNumber, BError error);
	BError cycleStartEvent(UInt32 cycleNumber);
	BError cycleStopEvent(UInt32 cycleNumber);
	BError dataEvent(DataInfo dataInfo);
private:
	Control&	ocontrol;
};
#endif
