/*******************************************************************************
 *	BError.h	BError Class
 *			T.Barnaby,	BEAM Ltd,	21/3/00
 *******************************************************************************
 */
#ifndef BERROR_H
#define BERROR_H	1

#include <BString.h>

/// Error return class
class BError {
public:
	enum		Type { NONE = 0, ERROR = 1 };			///< Type of error
			BError(int errNo = NONE, BString errStr = "");	///< Create object
			BError(BString errStr);				///< Create with error set and error string

	BError		copy();						///< Return an independant copy
				
	BError&		set(int errNo, BString errStr = "");		///< Set error number and message
	BError&		setError(BString errStr = "");			///< Set error type ERROR with optional message
	BString		getString() const;				///< Get error message
	int		getErrorNo() const;				///< Get The error number

			operator int() const;				///< Return error number
private:
	int		oerrNo;
	BString		oerrStr;
	
};

#endif
