/*******************************************************************************
 *	BBuffer.h	Buffer Class
 *			T.Barnaby,	BEAM Ltd,	27/2/94
 *******************************************************************************
 */
#ifndef BBUFFER_H
#define BBUFFER_H	1

#include <stdint.h>

class BBuffer {
/// Create and manipulate a data buffer. On creation the buffer size defaults to 1024 bytes.
public:
			BBuffer();
			~BBuffer();
	int		setSize(uint32_t size);						///< Sets the bufer size 
	int		setData(const void* data, uint32_t size);			///< Sets buffer data resized to contain the data
	int		writeData(uint32_t pos, const void* data, uint32_t size);	///< Writes data into buffer from offset pos 

	void*		data();								///< The data
	uint32_t	size();								///< Size of the buffer in bytes
private:
	uint32_t	osize;
	uint32_t	odatasize;
	void*		odata;
};
#endif
