/*******************************************************************************
 *	BFile.h		BEAM BFile access class
 *			T.Barnaby,	BEAM Ltd,	27/11/95
 *******************************************************************************
 */
#ifndef BFILE_H
#define BFILE_H	1

#include	<stdio.h>
#include	<BString.h>
#include	<BError.h>

/// File operations class
class BFile {
public:
			BFile();
			BFile(BString name, BString mode);		///< Create opened specifed file
			BFile(const BFile& file);			///< Create opened specified file
			~BFile();

	BError		open(BString name, BString mode);		///< Open file
	BError		open(FILE* file);				///< Assign object to opened file handle
	BError		close();					///< Close file
	
	BError		error();					///< Returns current error state.
	FILE*		getFd();					///< File descriptor
	int		length();					///< File size in bytes
	int		setVBuf(char* buf, int mode, size_t size);	///< Set stream buffering options

	int		read(void* buf, int nbytes);			///< Read from file
	int		readString(BString& str);			///< Read string. (ref fgets)

	int		write(const void* buf, int nbytes);		///< Write to file
	int		writeString(const BString& str);		///< Write string to file

	int		seek(int pos, int whence);			///< Set seek position
	
	int		printf(const char* fmt, ...);			///< Formated print into the file

	BFile&		operator=(const BFile& file);			
private:
	FILE*		ofile;
	BString		ofileName;
	BString		omode;
	BError		oerror;
};

#endif
