/*******************************************************************************
 *	Gen.h		TMS State Table Generator
 *			T.Barnaby,	BEAM Ltd,	2007-03-15
 *******************************************************************************
 */

#ifndef Gen_h
#define Gen_h	1

#include <BError.h>
#include <BFile.h>
#include <BNameValue.h>
#include <TmsLib.h>
#include <TmsCycleParam.h>

typedef BNameValue<BString>	PNameValue;

class PNameValueList : public BNameValueList<BString> {
public:
	BString		getValue(BString name);
	void		setValue(BString name, BString value);
};

/// State/Phase table generation class
class Gen {
public:
				Gen();
				~Gen();

	BList<BString>		getTypes();
	BError			init(PNameValueList& params);	///< Initialises the generation with a set of parameters
	
	BError			generate(BString cycleType);	///< Runs the generator

protected:
	BError			genBeam1();
	BError			genBeam2();
	BError			genBeam3();
	BError			genBeam3Delay();
	BError			genTest1();

	void			setPhaseDelay();
		
	PNameValueList		oparams;			///< The list of name/value parameters
	Tms::CycleParamEdit	ocycleParam;
	BFile			ofile;				///< The file to output results to
	
	BString			oname;
	BString			ofileName;			///< The output file name
	double			osampleRate;			///< The sample rate
	double			ofref;				///< The FREF frequency
	int			ophaseTableFile;		///< Flag to generate a phase table ASCII file
	int			ouseMsbFref;			///< Flag to use the PhaseTable address MSB as the FREF local reference
	int			opllInitialFrequencyDelay;	///< The PLL initial frequency load delay in ms
	int			ophaseDelay;			///< The phase delay to add to all channels
	int			ophaseDelayAll;			///< The phase delay to set all channels to
};

#endif
