/*
* Title:	BQComboBox.h
* Author:	M.Thomas BEAM Ltd
* Date:		2005-10-27
*
* Contents:	Qt combo box that can be setup from a struct. Additionally support a signal
*		passing the object.
*/

#ifndef BQCOMBOBOX_H
#define BQCOMBOBOX_H

#include <qcombobox.h>


typedef struct {
	int	index;		
	char*	label;
	double	value;
	double	isDefault;
} ComboDefinition;		


/*! Enhanced QComboBox supporting setup from a struct and a signal that exports a
* pointer to the object.
*/

class BQComboBox;

class	BQComboBox : public QComboBox {
	Q_OBJECT
public:
	BQComboBox(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	BQComboBox(ComboDefinition* def,QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
	~BQComboBox();

	void	setId(int id);					///< Set an Id on the object 
	void	setValue(double);				///< Sets value if posible
	double	getValue();					///< Returns currently selected value
	double	getDefault();					///< Returns the default value
signals:
	void	activated(BQComboBox* t,int id,int val);	///< Signal Emitted on activate. val is the cuttently selected value
private slots:
	void	activated(int val);
private:
	void	initWithDefinition(ComboDefinition* def);	///< Load Combo with options and default values


	int			oid;
	ComboDefinition*	odefinition;
};	

#endif
