/*******************************************************************************
 *	TmsEventServerList.cc	TMS List of Event Servers
 *			T.Barnaby,	BEAM Ltd,	2007-04-19
 *******************************************************************************
 */

#include <stdlib.h>
#include <stdint.h>
#include <TmsEventServerList.h>

namespace Tms {

TmsEventServerList::TmsEventServerList(){
}

TmsEventServerList::~TmsEventServerList(){
	olock.lock();

	olock.unlock();
}


BError TmsEventServerList::append(BString name){
	BError		err;
	TmsEvent*	e = new TmsEvent(name);

#ifdef ZAP
	if(err = e->connectService(name)){
		delete e;
		printf("TmsEventServerList::append: Connection Error: %s\n", err.getString().retStr());
		return err;
	}
#endif
	
	olock.lock();

	oeventServers.append(e);

	olock.unlock();

	return err;
}

BError TmsEventServerList::del(BString name){
	BError	err;
	BIter	i;

	olock.lock();

	for(oeventServers.start(i); !oeventServers.isEnd(i); ){
		if(oeventServers[i]->getServiceName() == name){
			delete oeventServers[i];
			oeventServers.del(i);
		}
		else {
			oeventServers.next(i);
		}
	}

	olock.unlock();

	return err;
}


BError TmsEventServerList::errorEvent(UInt32 cycleNumber, BError error){
	BError	err;
	BIter	i;

	olock.lock();

	for(oeventServers.start(i); !oeventServers.isEnd(i); ){
		if(err = oeventServers[i]->errorEvent(cycleNumber, error)){
			if(err.getErrorNo() < 0){
				delete oeventServers[i];
				oeventServers.del(i);
			}
			else {
				oeventServers.next(i);
			}
		}
		else {
			oeventServers.next(i);
		}
	}

	olock.unlock();

	return err;
}

BError TmsEventServerList::cycleStartEvent(UInt32 cycleNumber){
	BError	err;
	BIter	i;

	olock.lock();
	
	for(oeventServers.start(i); !oeventServers.isEnd(i); ){
		if(err = oeventServers[i]->cycleStartEvent(cycleNumber)){
			if(err.getErrorNo() < 0){
				delete oeventServers[i];
				oeventServers.del(i);
			}
			else {
				oeventServers.next(i);
			}
		}
		else {
			oeventServers.next(i);
		}
	}

	olock.unlock();

	return err;
}

BError TmsEventServerList::cycleStopEvent(UInt32 cycleNumber){
	BError	err;
	BIter	i;

	olock.lock();

	for(oeventServers.start(i); !oeventServers.isEnd(i); ){
		if(err = oeventServers[i]->cycleStopEvent(cycleNumber)){
			if(err.getErrorNo() < 0){
				delete oeventServers[i];
				oeventServers.del(i);
			}
			else {
				oeventServers.next(i);
			}
		}
		else {
			oeventServers.next(i);
		}
	}

	olock.unlock();

	return err;
}

BError TmsEventServerList::dataEvent(DataInfo dataInfo){
	BError	err;
	BIter	i;

	olock.lock();

	for(oeventServers.start(i); !oeventServers.isEnd(i); ){
		if(err = oeventServers[i]->dataEvent(dataInfo)){
			if(err.getErrorNo() < 0){
				delete oeventServers[i];
				oeventServers.del(i);
			}
			else {
				oeventServers.next(i);
			}
		}
		else {
			oeventServers.next(i);
		}
	}

	olock.unlock();

	return err;
}

}
