/*******************************************************************************
 *	BDir.h		BEAM Dir access class
 *			T.Barnaby,	BEAM Ltd,	8/10/96
 *				updated by	D.Korchagin,	CERN AB-BI-SW,	2007-08-31
 *******************************************************************************
 */
#ifndef BDIR_H
#define BDIR_H	1

#include	<BList.h>
#include	<BString.h>
#include	<BError.h>
#include	<sys/stat.h>

#ifndef __Lynx__
#else
typedef unsigned long long ino64_t;
typedef long long off64_t;
typedef unsigned long blksize_t;
typedef unsigned long long blkcnt64_t;

struct stat64 {
    dev_t st_dev;
    ino64_t st_ino;
    mode_t st_mode;
    nlink_t st_nlink;
    uid_t st_uid;
    gid_t st_gid;
    dev_t st_rdev;
    off64_t st_size;
    time_t st_atime;
    time_t st_mtime;
    time_t st_ctime;
    blksize_t st_blksize;
    blkcnt64_t st_blocks;
    mode_t st_attr;
};
#endif

/// File system directory class. 
class BDir : public BList<struct dirent*> {
public:
			BDir();
			BDir(BString name);
			~BDir();

	BError		open(BString name);		///< Reads named directory 
	BError		error();			///< Current value of error
	BError		read();				///< read/re-reads directory 
	void		clear();			///< Clears list

	void		setWild(BString wild);		///< Set wildcard filter string used on read
	void		setSort(int on);		///< Set alpha sort on/off

	BString		entryName(BIter i);		///< Get filename
	struct stat	entryStat(BIter i);		///< Get file stats
	struct stat64	entryStat64(BIter i);		///< Get file stats 64

private:
	BError		oerror;
	BString		odirname;
	BString		owild;
	int		osort;
};

#endif
