/*
* Title:	StatusWin.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Status Display
*
* Mod Rec:
*
*/

#include <StatusWin.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qvgroupbox.h>
#include <qmessagebox.h>


const int	REFRESH_MS = 1000;

StatusWin::StatusWin(QWidget* w,Control& c) : ocontrol(c)  {
	QVGroupBox*	t = new QVGroupBox("Status",this,"Status");
	QPushButton*	refreshButton;

	ostatus = new QTextEdit(t);
	refreshButton = new QPushButton("Refresh",t);


	refreshButton->setMaximumWidth(200);	

	owarningActive = false;
	oticker = new QTimer();

	QFont f("courier");
	f.setPointSize(10);
	ostatus->setFont(f);

	connect(refreshButton,SIGNAL(clicked()),this,SLOT(updateForced()));
	connect(&ocontrol,SIGNAL(newConnection()),this,SLOT(updateForced()));
        connect(oticker, SIGNAL(timeout()), this, SLOT(updateTimed()));
}
	
StatusWin::~StatusWin() {}


void StatusWin::updateTimed() {
	if (isVisible())
		getStatus();
}

void StatusWin::updateForced() {
	owarningActive = false;
	getStatus();
}

void StatusWin::show() {
	owarningActive = false;
	update();
//	oticker->start( REFRESH_MS, FALSE ); 	
	QWidget::show();
}

void StatusWin::hide() {
	oticker->stop(); 	
	QWidget::hide();
}

void StatusWin::getStatus() {
	BError			err;
	BIter			i;
	BList<Tms::NameValue>	l;
	BString			name;
	BString			value;
	
	if (err = ocontrol.getStatus(l)) {
		warningDialog("Reading Status",err);
		return;
	}
	ostatus->clear();

	for (l.start(i);! l.isEnd(i);l.next(i)) {
		BString	s;
		name = l[i].name.pad(30);
		value = l[i].value;
		s.printf("%s %s\n",name.retStr(),value.retStr());
		ostatus->append(s.retStr());
	}
}

void	StatusWin::warningDialog(BString title, BError err){
	BString	m;

	if (owarningActive)
		return;
	owarningActive = true;
	m = BString("<h5>") + title + "</h5><p>" + err.getString() + "</p>";
	QMessageBox::warning(this, "Warning", m.retStr());
}
