/*******************************************************************************
 *	Client.cc	HomeNet RPC protocol test client
 *			T.Barnaby,	BEAM Ltd,	9/5/03
 *******************************************************************************
 */
#include <stdio.h>
#include <stdlib.h>
#include <BString.h>
#include <Test1C.h>

int main(int argc, char** argv){
	BNetAddress		nadd("", 11000);
	HomeNet::Test1		client;
	BError			err;
	int			r;
	Int32			a1;
	Int32			a2;
	BList<HomeNet::DataA>	l1;
	BList<HomeNet::DataA>	l2;
	int			n;
	BIter			i;
	
	
	if(err = client.connect(nadd)){
		cerr << err.getString() << "\n";
		return 1;
	}

#ifdef ZAP	
	r = client.getStatus(a1, a2);
	cout << "Result: " << r << "\n";
#endif

#ifndef ZAP	
	for(n = 0; n < 5; n++){
		HomeNet::DataA	d;
		
		d.a = n;
		d.b = BString("Test ") + n;
		l1.append(d);
	}
	
	r = client.sendGetList(l1, l2);
	cout << "ListResult: " << r << " Len: " << l2.number() << "\n";
	for(l2.start(i); !l2.isEnd(i); l2.next(i)){
		printf("Got: %d %s\n", l2[i].a, l2[i].b.retStr());
	}
#endif
	return 0;
}
