/*******************************************************************************
 *	Main.cpp	TMS Web interface
 *			T.Barnaby,	BEAM Ltd,	2007-05-23
 *******************************************************************************
 *
 *	This application provides a web interface to the TMS system.
 */
#include <iostream>
#include <errno.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include <BEntry.h>
#include <BFile.h>
#include <Control.h>
#include <sys/time.h>
#include <Debug.h>

Config		config;

void usage(void) {
	cerr << "Usage:\ttmsWeb [options]\n";
	cerr << " --help             - Help on command line parameters\n";
	cerr << " -d 0x1122          - Set Debug mask\n";
	cerr << " -f                 - Run in the foreground\n";
	cerr << "\n";
}

static struct option options[] = {
		{ "?",			0, NULL, 0 },
		{ "h",			0, NULL, 0 },
		{ "help",		0, NULL, 0 },
		{ "d",			1, NULL, 0 },
		{ "f",			0, NULL, 0 },

		{ 0,0,0,0 }
};

int main(int argc, char** argv){
	BError			err;
	int			c;
	int			optIndex = 0;
	BString			s;
	Control			control;
	int			foreground = 0;
	
	while((c = getopt_long_only(argc, argv, "", options, &optIndex)) == 0){
		s = options[optIndex].name;
		if(s == "help" || s == "h" || s == "?"){
			usage();
			return 1;
		}
		else if(s == "d"){
			bdebug = strtol(optarg, 0, 0);
		}
		else if(s == "f"){
			foreground = 1;
		}
	}
	
	if(optind != argc){
		usage();
		return 1;
	}
	
	if(!foreground)
		daemon(0, 0);

	if(err = control.init()){
		cerr << "Error: " << err.getString() << "\n";
		return 1;
	}

	control.run();	

	return 0;
}
