/*******************************************************************************
 *	TmsPuApi.h	Produced by Bidl
 *******************************************************************************
 */
#ifndef TmsPuApi_H
#define TmsPuApi_H	1

#include <BString.h>
#include <BList.h>
#include <BArray.h>
#include <TmsS.h>

using namespace Tms;

class Control;

class PuControlServer : public Tms::PuControlService {
public:
		PuControlServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError init();
	BError setProcessPriority(BUInt32 priority);
	BError configure(BUInt32 ring, ConfigInfo configInfo);
	BError setControlInfo(CycleParam params);
	BError setNextCycle(BUInt32 cycleNumber, BString cycleType);
	BError test(BList<BError>& errors);
	BError getStatus(BList<NameValue>& statusList);
	BError getStatistics(BList<NameValue>& statsList);
	BError getMasterPuChannel(PuChannel& puChannel);

	BError setTestMode(PuChannel puChannel, BUInt32 testOutput, BUInt32 timingDisableMask);
	BError setTimingSignals(PuChannel puChannel, BUInt32 timingSignals);
	BError captureDiagnostics(PuChannel puChannel, TestCaptureInfo captureInfo, BArray<BUInt64>& data);
	BError setTestData(PuChannel puChannel, BInt32 on, BArray<BUInt32> data);	///< This function will set a PU channel to sample data from memory rather than the ADC's
	BError setPupeConfig(PuChannel puPhysChannel, PupeConfig pupeConfig);
	BError getPupeConfig(PuChannel puPhysChannel, PupeConfig& pupeConfig);
private:
	Control&	ocontrol;
};

class PuProcessServer : public Tms::PuProcessService {
public:
		PuProcessServer(Control& control, BoapServer& server, BString name);
	BError getVersion(BString& version);
	BError getStatus(PuChannel puChannel, PuStatus& puStatus);
	BError getCycleInformation(BUInt32 cycleNumber, CycleInformation& cycleInformation);
	BError getData(PuChannel puChannel, DataInfo dataInfo, Data& data, BUInt32& orbitNumber);

	BError addEventServer(BString name);
	BError requestData(PuChannel puChannel, DataInfo dataInfo);
private:
	Control&	ocontrol;
};

#endif
