/*
* Title:	ConfigureWin.cpp 
* Author:	M.Thomas BEAM Ltd
* Date:		2007-02-13
*
* Contents:	Configuration Data entry and control window
*
* Mod Rec:
*
*/


#include <ConfigureWin.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qvgroupbox.h>
#include <TmsD.h>
#include <BFile.h>
#include <qlayout.h>
#include <qmessagebox.h>
#include <Globals.h>

const	int	virtualChannels = 50;
const	int	moduleNumCol = 1;
const	int	pupeNumCol = 2;
const	int	pupeChanCol = 3;


ConfigureWin::ConfigureWin(QWidget* w,Control& c) : ocontrol(c)  {
	BString		s;
	QPushButton*	reconfigButton;
	QPushButton*	addButton;
	QPushButton*	delButton;
	QLabel*		label;	
	QGridLayout*	gridLayout;

	QString		title0("Virtual Channel");
	QString		title1("Module Number");
	QString		title2("Pupe Number");
	QString		title3("Pupe Channel");

	gridLayout 	= new QGridLayout(this,3,5);
	label 		= new QLabel(this,"explanation");
	opuParams 	= new QTable(this,"table");
	
//Qt3.3 Bug ?
//	QHBox*		h = new QHBox(this,"");
//	reconfigButton 	= new QPushButton("Reconfigure",this,"reconfigure");
//	addButton 	= new QPushButton("Add Channel",this,"add");
	reconfigButton 	= new QPushButton("Reconfigure",this,"reconfigure");
	addButton 	= new QPushButton("Add Channel",this,"add");
	delButton 	= new QPushButton("Delete Last Channel",this,"addl");

	reconfigButton->setMaximumWidth(200);
	addButton->setMaximumWidth(200);

	gridLayout->addItem(new QSpacerItem(50,10),0,0);
	gridLayout->addWidget(label,0,1);

	gridLayout->addItem(new QSpacerItem(60,10),1,0);
	gridLayout->addWidget(opuParams,1,1);
	gridLayout->addItem(new QSpacerItem(60,10),1,2);


//Qt3.3 Bug ?
//	gridLayout->addMultiCellWidget(h,2,2,0,5);

//	gridLayout->addMultiCellWidget(reconfigButton,2,2,0,1);
//	gridLayout->addMultiCellWidget(addButton,2,2,2,3);
//	gridLayout->addMultiCellWidget(delButton,2,2,4,5);

	gridLayout->addWidget(reconfigButton,2,0);
	gridLayout->addWidget(addButton,2,1);
	gridLayout->addWidget(delButton,2,2);

	gridLayout->setSpacing(20);
	gridLayout->setMargin(20);

	opuParams->setNumCols(4);
	opuParams->horizontalHeader()->setLabel( 0,title0);
	opuParams->horizontalHeader()->setLabel( 1,title1);
	opuParams->horizontalHeader()->setLabel( 2,title2);
	opuParams->horizontalHeader()->setLabel( 3,title3);
	
	opuParams->setColumnReadOnly(0,true);
	opuParams->verticalHeader()->hide();
	opuParams->setLeftMargin(0);
		
	opuParams->setColumnWidth(0,this->fontMetrics().width(title0) + 30);
	opuParams->setColumnWidth(1,this->fontMetrics().width(title1) + 30);
	opuParams->setColumnWidth(2,this->fontMetrics().width(title2) + 30);
	opuParams->setColumnWidth(3,this->fontMetrics().width(title3) + 30);
	
	opuParams->setFixedWidth(500);
	opuParams->setColumnStretchable(2,true);

	s = "<p><b>Mapping of Virtual Channel to Pickups<b></p>";
	s += "<p>Enter the module number, pickup number and pickup channel to be associated with a virtual channel</p>";
	
	label->setText(s.retStr());
	readConfig();
	connect(reconfigButton,SIGNAL(clicked()),this,SLOT(reconfigure()));
	connect(addButton,SIGNAL(clicked()),this,SLOT(addChannel()));
	connect(delButton,SIGNAL(clicked()),this,SLOT(delChannel()));
	connect(&ocontrol,SIGNAL(newConnection()),this,SLOT(update()));
}
	
ConfigureWin::~ConfigureWin() {}

void	ConfigureWin::update() {
	if (! isVisible())
		return;
	readConfig();
}


void	ConfigureWin::show() {
	update();
	QWidget::show();	
}

void	ConfigureWin::readConfig() {
	BError		err;
	unsigned int	n;
	Tms::ConfigInfo	info;
	QString		s;


	if (err = ocontrol.getConfiguration(info)) {			//Expected if no connection
		return;
	}
	opuParams->setNumRows(info.puReferences.size());
	
	for (n = 0;n < info.puReferences.size();n++) {
		Tms::PuChannel	c;
		BString		moduleNum = info.puReferences[n].moduleNum;
		BString		pupeNum = info.puReferences[n].pupeNum;
		BString		pupeChan = info.puReferences[n].pupeChan;
	
		s.setNum(n + 1);
		opuParams->setText(n,0,s);
		opuParams->setText(n,1,moduleNum.retStr());
		opuParams->setText(n,2,pupeNum.retStr());
		opuParams->setText(n,3,pupeChan.retStr());
	}
}

void ConfigureWin::reconfigure() {
	BError		err;
	int		n;
	Tms::ConfigInfo	config;

	for (n = 0;n < opuParams->numRows();n++) {
		Tms::PuChannel	c;
		c.moduleNum = opuParams->text(n,1).toUInt();
		c.pupeNum = opuParams->text(n,2).toUInt();
		c.pupeChan = opuParams->text(n,3).toUInt();
		config.puReferences.push_back(c);
	}
	if (err = ocontrol.reconfigure(config)) {
		warningDialog("Channel Configuation",err);
		return;	
	}
	gstatusbar->message("Channels Reconfigured",2000);
}

void	ConfigureWin::addChannel(){
	QString	s;
	int	index;
	
	opuParams->insertRows(opuParams->numRows(),1);

	s.setNum(opuParams->numRows());
	
	index = opuParams->numRows() - 1;
	opuParams->setText(index,0,s);
	opuParams->setText(index,1,"0");
	opuParams->setText(index,2,"0");
	opuParams->setText(index,3,"0");
	opuParams->setCurrentCell(index,1);
}

void	ConfigureWin::delChannel(){
	opuParams->removeRow(opuParams->numRows() - 1);
}


void	ConfigureWin::warningDialog(BString title, BError err){
	BString	m;
	
	m = BString("<h5>") + title + "</h5><p>" + err.getString() + "</p>";
	QMessageBox::warning(this, "Warning", m.retStr());
}

