-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_data_write_0.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description: This module splits the user data into the rise data and the fall data.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;
use work.mem_interface_small_parameters_0.all;
-- pragma translate_off
library UNISIM;
use UNISIM.VCOMPONENTS.ALL;
-- pragma translate_on

entity mem_interface_small_data_write_0 is 
port (
      CLK                  : in std_logic;
      CLK90                : in std_logic;
      RESET0               : in std_logic;
      RESET90              : in std_logic;
      CTRL_DUMMY_WR_SEL    : in std_logic;     
      WDF_DATA             : in std_logic_vector(dq_width*2-1 downto 0);
      MASK_DATA            : in std_logic_vector(dm_width*2-1 downto 0);
      CTRL_WREN            : in std_logic;
      CTRL_DQS_RST         : in std_logic;
      CTRL_DQS_EN          : in std_logic;
      wr_data_fall         : out std_logic_vector(dq_width-1 downto 0);
      wr_data_rise         : out std_logic_vector(dq_width-1 downto 0);
      mask_data_fall       : out std_logic_vector(data_mask_width-1 downto 0);
      mask_data_rise       : out std_logic_vector(data_mask_width-1 downto 0);
      wr_en        	   : out std_logic;
      dqs_rst              : out std_logic;   
      dqs_en           	   : out std_logic   
      
      );
end entity;

architecture arc_data_write of mem_interface_small_data_write_0 is



signal dqs_rst_r1          : std_logic;
signal dqs_rst_r2          : std_logic;
signal dqs_en_r1           : std_logic;
signal dqs_en_r2           : std_logic;
signal dqs_en_r3           : std_logic;

signal wr_en_clk270_r1     : std_logic;
signal wr_en_clk90_r3      : std_logic;

signal dummy_rise_pattern     : std_logic_vector(dq_width-1 downto 0);
signal dummy_fall_pattern     : std_logic_vector(dq_width-1 downto 0);
signal dummy_flag             : std_logic;
signal CTRL_DUMMY_WR_SEL_270  : std_logic;
signal CTRL_DUMMY_WR_SEL_90   : std_logic;
signal CTRL_DUMMY_WR_SEL_r1   : std_logic;

signal patA  : std_logic_vector(143 downto 0);
signal pat5  : std_logic_vector(143 downto 0);
signal  pat9  : std_logic_vector(143 downto 0);
signal  pat6  : std_logic_vector(143 downto 0);



begin

patA <=  X"AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA";
pat5 <=  X"555555555555555555555555555555555555";
pat9 <=  X"999999999999999999999999999999999999";
pat6 <=  X"666666666666666666666666666666666666";
dqs_rst 	<= dqs_rst_r2;
dqs_en 		<= dqs_en_r3;
wr_en           <= wr_en_clk90_r3;

process(CLK90)
   begin
     if (CLK90'event and CLK90 = '0') then 
       if (RESET90 = '1') then   
         wr_en_clk270_r1       <= '0';
         dqs_rst_r1            <= '0';
         dqs_en_r1             <= '0'; 
	 CTRL_DUMMY_WR_SEL_270  <= '0';         
       else                         
         wr_en_clk270_r1          <= CTRL_WREN;
         dqs_rst_r1               <= CTRL_DQS_RST;
         dqs_en_r1                <= not CTRL_DQS_EN; 
	 CTRL_DUMMY_WR_SEL_270  <= CTRL_DUMMY_WR_SEL;
       end if;
     end if;
   end process;

 process (CLK)
   begin
     if (CLK'event and CLK = '0') then 
       if (RESET0 = '1') then   
         dqs_rst_r2               <= '0';
         dqs_en_r2                <= '0';
         dqs_en_r3                <= '0';
       else
         dqs_rst_r2               <= dqs_rst_r1;
         dqs_en_r2                <= dqs_en_r1;
         dqs_en_r3                <= dqs_en_r2;
       end if;
     end if;
   end process;

process(CLK90)
   begin
     if (CLK90'event and CLK90 = '1') then 
       if (RESET90 = '1') then   
         wr_en_clk90_r3  <= '0';
	 CTRL_DUMMY_WR_SEL_90  <='0';
         CTRL_DUMMY_WR_SEL_r1  <= '0';
       else                    
         wr_en_clk90_r3  <= wr_en_clk270_r1 ;           							
         CTRL_DUMMY_WR_SEL_90  <= CTRL_DUMMY_WR_SEL_270;
         CTRL_DUMMY_WR_SEL_r1 <= CTRL_DUMMY_WR_SEL_90;
       end if;
     end if;
   end process;
   
process(CLK90)
begin
 if (CLK90'event and CLK90 = '1') then 
    if (RESET90 = '1') then   
      dummy_rise_pattern <= (others =>'0');
      dummy_fall_pattern <= (others =>'0');
      dummy_flag <= '1';

   elsif(CTRL_DUMMY_WR_SEL_90 = '1') then 
      	if(dummy_flag='1') then 
       		dummy_rise_pattern <= patA((dq_width-1) downto 0);
       		dummy_fall_pattern <= pat5((dq_width-1) downto 0);
        else	
		dummy_rise_pattern <= pat9((dq_width-1) downto 0);
		dummy_fall_pattern <= pat6((dq_width-1) downto 0);
	end if;  
    	dummy_flag <=  not dummy_flag;
  end if;
end if;
end process;

wr_data_rise <= dummy_rise_pattern when (CTRL_DUMMY_WR_SEL_r1 = '1') else WDF_DATA((dq_width*2)-1 downto dq_width);
wr_data_fall <= dummy_fall_pattern when (CTRL_DUMMY_WR_SEL_r1 ='1') else WDF_DATA((dq_width-1) downto 0); 





mask_data_rise <= (others => '0') when (CTRL_DUMMY_WR_SEL_r1 ='1' or wr_en_clk90_r3 ='0') else MASK_DATA((dm_width*2)-1 downto dm_width);
mask_data_fall <= (others => '0') when (CTRL_DUMMY_WR_SEL_r1 ='1' or wr_en_clk90_r3 ='0') else  MASK_DATA((dm_width-1) downto 0);


end arc_data_write;
