/*******************************************************************************
 *	DataAcquire.h	DataAcquire process
 *			T.Barnaby,	BEAM Ltd,	2007-02-07
 *******************************************************************************
 */
#ifndef DataAcquire_H
#define DataAcquire_H	1

#include <stdint.h>
#include <TmsApi.h>
#include <BError.h>

class Control;

/// The main system DataAcquire class
class DataAcquire {
public:
			DataAcquire(Control& control);
			~DataAcquire();

	// Main functionality	
	BError		init();				///< Initialise the system

	BError		getData(DataInfo dataInfo, Data& data);
	BError		requestData(DataInfo dataInfo);

private:
	BError		getSimData(DataInfo dataInfo, Data& data);	///< return simulated data

	// DataAcquire data
	Control&	ocontrol;			///< The main Control class
};

#endif
