/*******************************************************************************
 *	Boaptest.cc	Boap Test Client
 *			T.Barnaby,	BEAM Ltd,	8/3/05
 *******************************************************************************
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <iostream>

#include <BoapnsC.h>
#include <TestcaseD.h>
#include <TestcaseC.h>

int usage(){
	fprintf(stderr, "Usage: boaptest [options]\n");
	return 1;
}

BError listServices(){
	Boapns::Boapns			boapns("boapns");
	BError				err;
	BList<Boapns::BoapEntry>	entryList;
	BIter				i;
	
	if(err = boapns.getEntryList(entryList)){
		fprintf(stderr, "Error: %s\n", err.getString().retStr());
	}
	else {
		printf("listServices\n");
		for(entryList.start(i); !entryList.isEnd(i); entryList.next(i)){
			printf("Service: Entry(%s, %x,%d,%d)\n", entryList[i].name.retStr(), entryList[i].ipAddress, entryList[i].port, entryList[i].service);
		}
	}
	return err;
}

BError testLight(){
	BError			err;
	Appliance::Light	light("//localhost/light");
	
	printf("Switch on light\n");
	err = light.setLevel(33);
	printf("Switch on light result: %s\n", err.getString().retStr());

	return err;
}

BError testTv(){
	BError			err;
	Appliance::Tv		tv("//localhost/tv");
	Appliance::TvRecorder	tvRecorder("//localhost/tv/recorder");
	
	printf("SetChannel\n");
	err = tv.setChannel(33);
	printf("Result: %s\n", err.getString().retStr());

	printf("SetChannel:\n");
	err = tvRecorder.setChannel(33);
	printf("Result: %s\n", err.getString().retStr());

	return err;
}

int main(int argc, char** argv){
	int			a;
	BError			err;
	
	for(a = 1; a < argc; a++){
		if(argv[a][0] == '-'){
		}
	}

	err = listServices();
	err = testLight();
	err = testTv();
		
	return err.getErrorNo();
}
