/*******************************************************************************
 *	BRWLock.cc	BRWLock Classes
 *			T.Barnaby,	BEAM Ltd,	3/07/03
 *******************************************************************************
 */
#include <BRWLock.h>

BRWLock::BRWLock(){
	pthread_rwlock_init(&olock, 0);
}

BRWLock::BRWLock(const BRWLock& rwlock){
	pthread_rwlock_init(&olock, 0);
}

BRWLock& BRWLock::operator=(const BRWLock& lock){
	return *this;
}

BRWLock::~BRWLock(){
	pthread_rwlock_destroy(&olock);
}

int BRWLock::rdLock(){
	return pthread_rwlock_rdlock(&olock);
}

int BRWLock::tryRdLock(){
	return pthread_rwlock_tryrdlock(&olock);
}

int BRWLock::wrLock(){
	return pthread_rwlock_wrlock(&olock);
}

int BRWLock::tryWrLock(){
	return pthread_rwlock_trywrlock(&olock);
}

int BRWLock::unlock(){
	return pthread_rwlock_unlock(&olock);
}

