/*******************************************************************************
 *	BFile.h		BEAM BFile access class
 *			T.Barnaby,	BEAM Ltd,	27/11/95
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BFILE_H
#define BFILE_H	1

#include	<stdio.h>
#include	<BTypes.h>
#include	<BString.h>
#include	<BError.h>

/// File operations class
class BFile {
public:
			BFile();
			BFile(const BFile& file);			///< Create opened specified file
			~BFile();

	BError		open(BString name, BString mode);		///< Open file
	BError		open(FILE* file);				///< Assign object to opened file handle
	BError		open(int fd, BString mode);			///< Assign object to opened file descriptor
	BError		close();					///< Close file
	
	int		isOpen();					///< Returns 1 if the file is open
	int		isEnd();					///< Returns 1 if at the end of the file, 0 otherwise
	FILE*		getFd();					///< File descriptor
	BUInt64		length();					///< File size in bytes
	int		setVBuf(char* buf, int mode, size_t size);	///< Set stream buffering options

	int		read(void* buf, int nbytes);			///< Read from file
	int		readString(BString& str);			///< Read string. (ref fgets)
	char*		fgets(char* buf, size_t size);

	int		write(const void* buf, int nbytes);		///< Write to file
	int		writeString(const BString& str);		///< Write string to file

	int		seek(BUInt64 pos);				///< Set seek position
	BUInt64		position();					///< The files position
	
	int		printf(const char* fmt, ...);			///< Formated print into the file

	BError		truncate();					///< Truncate the file
	BError		flush();					///< Flush the file
	BString		fileName();					///< Return file name

	BFile&		operator=(const BFile& file);			
private:
	FILE*		ofile;
	BString		ofileName;
	BString		omode;
};

#endif
