-------------------------------------------------------------------------------
-- Copyright (c) 2005 Xilinx, Inc.
-- This design is confidential and proprietary of Xilinx, All Rights Reserved.
-------------------------------------------------------------------------------
--   ____  ____
--  /   /\/   /
-- /___/  \  / Vendor: Xilinx
-- \   \   \/ Version: 1.6
--  \   \ Application : MIG
--  /   / Filename: mem_interface_small_v4_dqs_iob.vhd
-- /___/   /\ Date Last Modified:  Wed Jun 1 2005
-- \   \  /  \Date Created: Mon May 2 2005
--  \___\/\___\
-- 
-- Device: Virtex-4
-- Design Name: DDR2_V4
-- Description     : This module places the data stobes in the IOBs.
-------------------------------------------------------------------------------

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all;
use ieee.numeric_std.all;

library UNISIM;
use UNISIM.VCOMPONENTS.ALL;


entity mem_interface_small_v4_dqs_iob is 
port (
      CLK           : in std_logic;
      CAL_CLK       : in std_logic;
      RESET       : in std_logic;

      DLYINC        : in std_logic;
      DLYCE         : in std_logic;
      DLYRST        : in std_logic;
      CTRL_DQS_RST  : in std_logic;
      CTRL_DQS_EN   : in std_logic;
      DDR_DQS       : inout std_logic;
      DDR_DQS_L     : inout std_logic;
      DQS_RISE      : out std_logic
     );
end entity;     

architecture arc_v4_dqs_iob of mem_interface_small_v4_dqs_iob is

component FD
  port(
       Q  : out STD_LOGIC;
       C  : in STD_LOGIC;
       D  : in STD_LOGIC
      );
end component;

component IDELAY
generic(
    IOBDELAY_TYPE  : string := "VARIABLE";
    IOBDELAY_VALUE : integer := 0
    );

port(
    O      : out std_ulogic;
    C      : in  std_ulogic;
    CE     : in  std_ulogic;
    I      : in  std_ulogic;
    INC    : in  std_ulogic;
    RST    : in  std_ulogic
    );
end component;

component IDDR
generic(
    DDR_CLK_EDGE : string := "SAME_EDGE_PIPELINED";
    SRTYPE       : string := "SYNC"
    );
port(
    Q1          : out std_ulogic;
    Q2          : out std_ulogic;
    C           : in  std_ulogic;
    CE          : in  std_ulogic;
    D           : in  std_ulogic;
    R           : in  std_ulogic;
    S           : in  std_ulogic
  );
end component;

component ODDR
generic(
    DDR_CLK_EDGE : string := "OPPOSITE_EDGE";
    SRTYPE       : string := "SYNC"
    );
port(
    Q           : out std_ulogic;
    C           : in  std_ulogic;
    CE          : in  std_ulogic;
    D1          : in  std_ulogic;
    D2          : in  std_ulogic;
    R           : in  std_ulogic;
    S           : in  std_ulogic
  );
end component;

component IOBUFDS
  port(
    O   : out   std_ulogic;
    IO  : inout std_ulogic;
    IOB : inout std_ulogic;
    I   : in    std_ulogic;
    T   : in    std_ulogic
    );
end component;

signal dqs_in          : std_logic;
signal dqs_out         : std_logic;
signal dqs_out_l       : std_logic;
signal dqs_delayed     : std_logic;
signal ctrl_dqs_en_r1  : std_logic;
signal vcc             : std_logic;
signal gnd             : std_logic;
signal clk180          : std_logic;
signal data1           : std_logic;
signal data2           : std_logic;
signal DQS_UNUSED  : std_logic;

 attribute equivalent_register_removal : string;
  attribute equivalent_register_removal of ctrl_dqs_en_r1 : signal is "no";
  attribute equivalent_register_removal of tri_state_dqs : label is "no";
  attribute iob : string;
  attribute iob of tri_state_dqs : label is "TRUE";

begin

 vcc         <= '1';
 gnd         <= '0';
 clk180      <= not CLK;
process(clk180)
begin
  if clk180'event and clk180 = '1' then
    if (CTRL_DQS_RST = '1') then
      data1 <= '0';
    else
      data1 <= '1';
    end if;
  end if;
end process;

process(clk180)
begin
  if clk180'event and clk180 = '1' then
    if (CTRL_DQS_RST = '1') then
      data2 <= '1';
    else
      data2 <= '0';
    end if;
  end if;
end process;


                            
idelay_dqs : IDELAY
generic map(
    IOBDELAY_TYPE  => "VARIABLE",
    IOBDELAY_VALUE => 0
    )

             port map (
                       O   => dqs_delayed,
                       I   => dqs_in,
                       C   => CAL_CLK,   
                       CE  => DLYCE,
                       INC => DLYINC,
                       RST => DLYRST
                       );
iddr_dqs :  IDDR 
generic map(
    DDR_CLK_EDGE => "SAME_EDGE_PIPELINED",
    SRTYPE       => "SYNC"
    )

      port map (
              Q1 =>DQS_RISE,
              Q2 =>DQS_UNUSED,
              C =>CLK,
              CE => vcc,           
              D => dqs_delayed,
              R => RESET,
              S =>gnd
              );
           
                                        
oddr_dqs : ODDR
generic map(
             DDR_CLK_EDGE => "OPPOSITE_EDGE",
             SRTYPE        => "SYNC"
           )

           port map (
                     Q  => dqs_out,
                     C  => clk180,
                     CE => vcc,
                     D1 => data1,
                     D2 => gnd,
                     R  => gnd,
                     S  => gnd
                     );
               
oddr_dqs_l : ODDR
generic map(
             DDR_CLK_EDGE => "OPPOSITE_EDGE",
             SRTYPE        => "SYNC"
           )

             port map (
                       Q  => dqs_out_l,
                       C  => clk180,
                       CE => vcc,
                       D1 => data2,
                       D2 => vcc,
                       R  => gnd,
                       S  => gnd
                       );

tri_state_dqs : FD
                port map (
                          D => CTRL_DQS_EN,
                          Q => ctrl_dqs_en_r1,
                          C => clk180
                          );
                  
iobuf_dqs : IOBUFDS
            port map (
                      O   => dqs_in, 
                      IO  => DDR_DQS, 
                      IOB => DDR_DQS_L, 
                      I   => dqs_out,
                      T   => ctrl_dqs_en_r1
                      );
                   
end arc_v4_dqs_iob;                                                                      
     
