/*******************************************************************************
 *	Tv.cc		Tv service
 *			T.Barnaby,	BEAM Ltd,	8/3/05
 *******************************************************************************
 */
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <iostream>

#include <TestcaseD.h>
#include <TestcaseS.h>
#include <TestcaseC.h>


class TvServer : public Appliance::TvService {
public:
			TvServer(BoapServer& server, BString name) : Appliance::TvService(server, name){}
	BError		setChannel(Int32 channel){
		BError	err;
		
		printf("Called: Tv::%s\n", __FUNCTION__);
		return err;
	}
};

class TvRecorder : public Appliance::TvRecorderService {
public:
			TvRecorder(BoapServer& server, BString name) : Appliance::TvRecorderService(server, name){}
	BError		setChannel(Int32 channel){
		BError	err;
		
		printf("Called: TvRecorder::%s\n", __FUNCTION__);
		return err;
	}
};


int main(int argc, char** argv){
	BoapServer		server;
	TvServer		tv(server, "tv");
	TvRecorder		tvRecorder(server, "tv/recorder");
	BError			err;

	if(err = server.init()){
		std::cerr << err.getString() << "\n";
		return 1;
	}
	
//	daemon(0, 0);

	server.run();
	
	return 0;
}
