/*******************************************************************************
 *	BBuffer.c	Buffer Class
 *			T.Barnaby,	BEAM Ltd,	27/2/94
 *******************************************************************************
 */
#include	<stdlib.h>
#include	<memory.h>
#include	<BBuffer.h>

#define		SIZE		1024

BBuffer::BBuffer(){
	osize = 0;
	odatasize = SIZE;
	odata = malloc(odatasize);
}

BBuffer::~BBuffer(){
	free(odata);
}

uint32_t BBuffer::size(){
	return osize;
}

int	BBuffer::setSize(uint32_t size){
	uint32_t	asize;

	asize = size;

	if(asize < SIZE)
		asize = SIZE;

	if(asize != odatasize){
		if((odata = realloc(odata, asize)) == 0){
			return 1;
		}
		odatasize = asize;
	}
	osize = size;
	return 0;
}

void*	BBuffer::data(){
	return odata;
}

int	BBuffer::setData(const void* data, uint32_t size){
	if(!setSize(size)){
		memcpy(odata, data, size);
		return 0;
	}
	else {
		return 1;
	}
}

int	BBuffer::writeData(uint32_t pos, const void* data, uint32_t size){
	if(odata && ((pos + size) <= osize)){
		memcpy((char*)odata + pos, data, size);
		return 0;
	}
	else {
		return 1;
	}
}
