/*******************************************************************************
 *	TmsCycleParam.h	TMS Client library functions
 *			T.Barnaby,	BEAM Ltd,	2007-06-19
 *******************************************************************************
 */

#ifndef TmsCycleParam_H
#define TmsCycleParam_H		1

#include <TmsLib.h>

namespace Tms {


class CycleParamState {
public:
			CycleParamState();
	void		clear();		///< Clear the entry
	void		setNext(int nextNum, BUInt32 nextPeriod, bool f1RefSigma, bool f1LoMsb, bool f2RefSigma, bool f2LoMsb, bool pllF2, bool acquire);
	
	BString		getString();	///< Returns the CycleParamState in string form
	BError		setString(BString str);	///< Sets the CycleParamState from a string
	
	BUInt32		num;		///< The state number	
	BUInt32		period;		///< The cycle period
	TmsState	state;		///< The TMS State
	BUInt32		bunchMask;	///< The set of bunches to capture bit mask
	BUInt32		mean1Mask;	///< The set of bunches to pass through meanFilter1
	BUInt32		mean2Mask;	///< The set of bunches to pass through meanFilter2
	BUInt32		lo1Harmonic;	///< The LO harmonic number used in this state
	double		lo1Phase;	///< The phase offset of the LO as a fraction of FREF (+-1.0)
	BUInt32		lo2Harmonic;	///< The LO harmonic number used in this state
	double		lo2Phase;	///< The phase offset of the LO as a fraction of FREF (+-1.0)
	double		gateWidth;	///< The gate pulse width as a fraction of LO (0 - 1.0)
	double		gatePhase;	///< The gate phase offset as a fraction of LO (0 - 1.0)
	double		blrWidth;	///< The gate pulse width as a fraction of LO (0 - 1.0)
	double		blrPhase;	///< The gate phase offset as a fraction of LO (0 - 1.0)
};

/// Cycle Parameter management class
class CycleParamEdit : public CycleParam {
public:
			CycleParamEdit();
			CycleParamEdit(const CycleParam& param);
	
	void		clear();

	BString		getString();					///< Gets the Cycle Parameters in a string format for writing to a file or display
	BError		setString(BString str);				///< Sets the Cycle Parameters from a string. For reading from a file
				
	BError		readFromFile(BString fileName);			///< Reads the Cycle Parameters from a file
	BError		writeToFile(BString fileName);			///< Writes the Cycle Parameters to a file

	BError		setStates(BList<CycleParamState> cycleStates);	///< Sets the Cycle Parameter states given the state information list.
	BError		getStates(BList<CycleParamState>& cycleStates);	///< Returns the state information list describing the Cycle Parameter states. These may not be present.

	static void	getDefaultState(CycleParamState& state);	///< Get the default settings for a state.
	static void	getdefaultPickupPositions(BArray<BInt32>& pos);	///< Get the default pickup positions.

private:
	double		value(int numSamples, int harmonic, double phase, int sample);
	int		bunch(int numSamples, int harmonic, double phase, int sample);
	BError		generateState(CycleParamState stateParam);
};

}
#endif
