/*******************************************************************************
 *	BRtc.h		Real Time Clock interface
 *			T.Barnaby,	BEAM Ltd,	19/5/04
 *	Copyright (c) 2012 All Right Reserved, Beam Ltd, http://www.beam.ltd.uk
 *******************************************************************************
 */
#ifndef BRTC_H
#define	BRTC_H

#include <BError.h>
#include <BThread.h>
#include <BCond.h>

/// Realtime clock
class BRtc {
public:
			BRtc();
			~BRtc();

	BError		init(int rate);		///< Setup interrupt rate
	void		wait(int delayUs);	///< Wait specified uS
private:
	int		ofd;
	int		orate;
};

/// Threaded real time clock
class BRtcThreaded : private BThread {
public:
			BRtcThreaded();
			~BRtcThreaded();

	BError		init(int rate);		///< Setup interrupt rate
	void		wait(int delayUs);	///< Wait specified uS
private:
	void*		function();
	BRtc		ortc;
	int		orate;
	BCond		ocond;
};
#endif
