/*******************************************************************************
 *	TmsEventServerList.h	TMS List of Event Servers
 *			T.Barnaby,	BEAM Ltd,	2007-04-19
 *******************************************************************************
 */

#ifndef TmsEventServerList_H
#define TmsEventServerList_H		1

#include <TmsD.h>
#include <TmsC.h>

namespace Tms {

class TmsEventServerList {
public:
				TmsEventServerList();
				~TmsEventServerList();
	
	BError			append(BString name);
	BError			del(BString name);
	
	// Event Sending functions
	BError			errorEvent(BUInt32 cycleNumber, BError error);	///< This event function gets called on a system error. The errorEvent object contains and error number and string describing the error. The getStatus() call can be used to fetch further information.
	BError			cycleStartEvent(BUInt32 cycleNumber);	///< This event function gets called on the CYCLE_START event with the cycle number about to be processed
	BError			cycleStopEvent(BUInt32 cycleNumber);	///< This event function gets called on the CYCLE_END event with the cycle number completed
	BError			dataEvent(DataInfo dataInfo);		///< This event function gets called when some requested data becomes available. The DataInfo object contains information on the data. The getData() call can be used to fetch the actual data.

private:
	BMutex			olock;
	BList<TmsEvent*>	oeventServers;
};

}

#endif
