/*******************************************************************************
 *	BMutex.cc	BMutex Classes
 *			T.Barnaby,	BEAM Ltd,	1/11/02
 *******************************************************************************
 */
#include <BMutex.h>

#define	MDEBUG	0

BMutex::BMutex(){
	pthread_mutex_init(&omutex, 0);
}

BMutex::BMutex(const BMutex& mutex){
	pthread_mutex_init(&omutex, 0);
}

BMutex& BMutex::operator=(const BMutex& mutex){
	return *this;
}

BMutex::~BMutex(){
	pthread_mutex_destroy(&omutex);
}

#if MDEBUG

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <linux/unistd.h>
#include <errno.h>

static pid_t gettid(){
	return syscall(__NR_gettid);
}

int BMutex::lock(){
	int	e;
	
	printf("BMutex::lock: %p Thread: %u\n", this, gettid()); 
	e = pthread_mutex_lock(&omutex);
	printf("BMutex::lock: %p: Thread: %u: Acquired\n", this, gettid()); 

	return e;
}

int BMutex::unlock(){
	printf("BMutex::unlock: %p Thread: %u\n", this, gettid()); 
	return pthread_mutex_unlock(&omutex);
}

int BMutex::tryLock(){
	return pthread_mutex_trylock(&omutex);
}

#else

int BMutex::lock(){
	return pthread_mutex_lock(&omutex);
}

int BMutex::unlock(){
	return pthread_mutex_unlock(&omutex);
}

int BMutex::tryLock(){
	return pthread_mutex_trylock(&omutex);
}

#endif
