/*******************************************************************************
 *	BFile.cc	BEAM BFile access class
 *			T.Barnaby,	BEAM Ltd,	27/11/95
 *	updated by	D.Korchagin,	CERN AB-BI-SW,	2007-08-31
 *******************************************************************************
 */
#ifndef __Lynx__
#else
#include	<stdarg.h>
#endif
#include	<BFile.h>
#include	<sys/stat.h>
#include	<string.h>
#include	<stdarg.h>
#include	<errno.h>

#define		STRBUF		10240

BFile::BFile(){
	ofile = NULL;
}

BFile::BFile(BString name, BString mode){
	oerror = open(name, mode);
}

BFile::BFile(const BFile& file){
	oerror = open(file.ofileName, file.omode);
}

BFile& BFile::operator=(const BFile& file){
	open(file.ofileName, file.omode);
	return *this;
}

BFile::~BFile(){
	close();
}

BError BFile::open(BString name, BString mode){
	BError	err;
	
	ofileName = name;
	omode = mode;
	if(! (ofile = fopen(name, mode)))
		err.setError(BString("Cannot open file: ") + name + ": " + strerror(errno));
	oerror = err;
	return err;
}

BError BFile::open(FILE* file){
	BError	err;

	ofile = file;
	oerror = err;
	return err;
}

BError BFile::close(){
	BError	err;
	
	if(ofile){
		if(fclose(ofile));
			err.setError(strerror(errno));
		ofile = 0;
	}
	return err;
}

FILE* BFile::getFd(){
	return ofile;
}

BError BFile::error(){
	return oerror;
}

int BFile::length(){
	struct stat	s;
	
	fstat(fileno(ofile), &s);
	return s.st_size;
}

int BFile::read(void* buf, int nbytes){
	return fread(buf, 1, nbytes, ofile);
}

int BFile::readString(BString& str){
	char	buf[STRBUF];
	BError	err;

	if(fgets(buf, STRBUF, ofile)){
		str = buf;
		return str.len();
	}
	else {
		return 0;
	}
}

int BFile::write(const void* buf, int nbytes){
	 return fwrite(buf, 1, nbytes, ofile);
}

int BFile::writeString(const BString& str){
	return fputs(str.retStr(), ofile);
}

int BFile::seek(int pos, int whence){
	return fseek(ofile, pos, whence);
}
int BFile::setVBuf(char* buf, int mode, size_t size){
	return setvbuf(ofile, buf, mode, size);
}

int BFile::printf(const char* fmt, ...){
	va_list	ap;
	
	va_start(ap, fmt);
	return vfprintf(ofile, fmt, ap);
}
