/*******************************************************************************
 *	BTimer.h		Quantel Quentin BTimers
 *			T.Barnaby,	BEAM Ltd,	3/2/04
 *******************************************************************************
 */
#ifndef BTIMER_H
#define	BTIMER_H

#include <BMutex.h>

/// Stopwatch style timer
class BTimer {
public:
			BTimer();
			~BTimer();

	void		start();		///< Start timer
	void		stop();			///< Stop timer
	void		clear();		///< Clear timer
	double		getElapsedTime();	///< Returns the elapsed time from the last start
	
	// Overall operations
	void		add(BTimer& timer);	///< Add two timers
	
	// Statistics
	double		average();		///< Average time is duration between start() and stop() / number of stops
	double		peak();			///< Peak time 
private:
	static double	getTime();
	
	BMutex		olock;
	unsigned int	onum;
	double		ostartTime;
	double		oendTime;
	double		oaverage;
	double		opeak;
};
#endif
